*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     This routine reads 'grid' card and extablishes parameters of the
*     current grid
*
*****
      subroutine setgrid(igrid)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

      if (igrid.eq.0) then

c        set the default value of grid points 
         no=1500
c        the starting point in rho variable
         rho=-6.d0
c        and the step size in rho 
         h  =d1/d16/d2/d2
         
         h3=h/d3
         h1=d2*h3
         ch=h*h/d12
         eh=exp(-h)

         rmax=0.d0
      else
         
         irmax=0
         call inpi(itmp)
         if (itmp.ne.inpiexit) then 
            no=itmp
            ftmp=0.d0
            call inpf(ftmp)
            if (ftmp.lt.0.d0) then 
               rho=ftmp
               ftmp=0.d0
               call inpf(ftmp)
               if (ftmp.ne.0.d0) then 
                  rmax=ftmp
                  irmax=1
               endif
            endif
         endif
         
         if (no.gt.maxno) then
            write(*,*) 'Error: too many grid points'
            stop 'setgrid'
         endif
         rhomax=rho+(no-1)*h
         if (irmax.eq.0) then
c           calculate the extent of the grid in r variable
            rmax=exp(rhomax)/z
         else
c           recalculate the step size if rmax is given
            rhomax=log(z*rmax)
            h=(rhomax-rho)/(no-1)
         endif

         h3=h/d3
         h1=d2*h3
         ch=h*h/d12
         eh=exp(-h)
      endif

      return
      end


