*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     Set some constants.
*
*****
      subroutine setconst
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      include 'common.inc'

c     velocity of light
      cvel=137.035 989 5d0

c pi from bc -l
c    scale=32
c    a(1)*4=           3.14159265358979323846264338327948
c    scale=64
c    a(1)*4=           3.14159265358979323846264338327950

      pii=atan(one)*four

c  DLAMCH determines double precision machine parameters: 
c  for the argument 'e' it is the relative machine precision

c
c      precis=dlamch('e')

      precis=one
      do i=1,10000
         precis=precis/two
         o=one+precis
         if ( o.eq.one ) goto 100
      enddo
 100  continue

c     Warning!

c     Precision calculated by the code below depends on compiler
c     optimization flags used. This routine must be compiled with the
c     minimum optimization on x86 systems to avoid reporting precision
c     of the extended IEEE 754 arithmetic.

c     t=one
c     do i=1,10000
c     t=t/two
c     o=one+t
c     if ( o.eq.one) goto 100
c     enddo
c100  continue
c     precis=t

c     set default lengths of integer and real constants and variables used

      i8tmp1=2**30
      i8tmp2=100000*i8tmp1
      i4tmp1=i8tmp2
      if (i4tmp1.eq.0) then
         lengthint=4
      else
         lengthint=8
      endif   

      if (precis.gt.1e-20) then
         lengthfp =8
      else
         lengthfp =16
      endif

      return
      end
