*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*	The scf subroutine determines self-consistent wave functions
*	(either all or those outside the fixed core)
*
*****
      subroutine scf(etotal,acfg,scftol,cfgtol,ld,new)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

      if (new .eq. 0) new = ncfg
      nc = ncfg - new + 1

      if ( iuh .eq. 0 .or. nc .le. 1 ) go to 101
      ncm = nc - 1
      do i = 1,ncm
         read (iuh,103) (et(i,j),j=1,i)
 103     format(5f14.7)
         do j = 1,i
            et(j,i) = et(i,j)
         enddo
 102     continue
      enddo

101   if ( cfgtol .eq. d0) cfgtol = cfgtoldef
      if ( scftol .eq. d0) scftol = scftoldef

      if ( ic .eq. 0 .and. ncfg .eq. 1 ) ic = 3 + (nwf + 1 - ib)/4

c FIXME tol not used
      tol = sqrt(z)*toldef
c      z2 = scftol*sqrt(z*nwf)
      z2 = scftol

      write (ouc,15)
15    format(//)

      write (ouc,16) ortho,omit,acfg,scftol,no,rmax,rho,h,z
16    format(10x,44horthogonality between configurations       =,l4/
     1       10x,44hweak orthogonalization during the scf cycle=,l4/
     2       10x,44haccelerating parameter for mchf iteration  =,f5.2/
     3       10x,44hscf convergence tolerance (functions)      =,1pd9.2,
     4      /10x,44hnumber of points in the maximum range      =,i5,
     5      /10x,44hmaximum range                              = ,1pd9.2
     6     ,/10x,44hinitial rho, h                             =,0pf5.1,
     7                                                         1pd9.2
     8     ,/10x,44hZ                                          =,0pf6.2)      

c  *****  set iteration paramiters

      ipr = 0
      econv = .false.
      last = .false.
      if (ib .gt. nwf ) last = .true.
      dp1 = d0
      etotal = d0

      if (nscf .eq. 0) nscf = maxnscf


      if ( .not.ld ) go to 9

      call diag(etotal,econv,acfg,cfgtol,nc,last)

      if (last) return
      if ( ncfg .gt. 1 .and. id .ne. 1) call array

c  *****  perform iterations

9     do i = 1,nscf

         write(ouc,7) i,cfgtol,z2
 7       format(//10x,17hiteration number ,i3/10x,16h----------------//
     1        10x,50hconvergence criteria:energy  (cfgtol)------------=,
     2        1pd9.1/
     3        10x,50h                    :function(scftol*sqrt(z*nwf))=,
     4        1pd9.1)
         dp1 = d0

         if (ib .gt. nwf) go to 12
         call grange

c  *****  solve each differential equation in turn

         write(ouc,14)
 14      format(20x,'El',10x,'Ed',13x,'Az',12x,'Norm',11x,'DPM',
     &        7x,'nj')
         do j = ib,nwf
            call de(j)

            if ( fail ) go to 3
            dp = dpm(j)*sqrt(sum(j))
            if ( dp1 .ge. dp ) go to 2
            dp1 = dp
            jj = j
 2          continue
         enddo
         if ((ncfg .eq. 1 .or. id .eq. 1) .and. dp1 .lt. z2) go to 6
         if ( ic .le. 0) go to 6

c  *****  solve ic differential eqations each time selecting
c  *****  the one with the largest dpm

         do ii = 1,ic
            call de(jj)
            if ( fail ) go to 3
            dp1 = d0
            do j = ib,nwf
               dp = sqrt(sum(j))*dpm(j)
               if ( dp1 .gt. dp ) go to 5
               jj = j
               dp1 = dp
 5             continue
            enddo
            if (dp1 .lt. z2) go to 6
         enddo

 6       continue

         if(irel.eq.0) call orthog
         
         if (.not.(ncfg .eq. 1 .or. id .eq. 1)) go to 12
         if (dp1 .gt. z2) go to 1
         if (dp1 .le. z2 .and. last ) go to 12
         last = .true.
         go to 1
         
 12      continue
         call diag(etotal,econv,acfg,cfgtol,nc,last)

         if ( ncfg .gt. 1 .and. id .ne. 1) call array

c  *****  if converged, solve each  again and test again

         if (ib .gt. nwf) return
         conv = econv .and. dp1 .le. z2
         if (conv .and. last) go to 99
         if (conv) last =.true.
         
c  *****  increase the convergence criterion for self-comsistency

 1       continue

c        If scf iteration limit is reached a proper message and summary
c        information is printed

c        Note that SCF energy tolerance is not doubled every SCF
c        iteration 

c        z2 = d2*z2

         write(ouc,8) el(jj),dp1
 8       format(/10x ,34hleast self-consistent function is ,a3,
     1        27h (weighted maximum change =,1pd10.2,1h))
         cfgtol = 1.4d0*cfgtol
      enddo
      
      write (ouc,13)
 13   format(/,10x,'Warning!',
     1     /,10x,'SCF iteration limit exceeded. ',
     2     /,10x,'SCF process has not converged to requested accuracy.')
      fail = .true.
      fail = .false.
      call diag(etotal,econv,acfg,cfgtol,nc,last)

 3    continue
      return
      
c     in cases when a qiasirelativistic potential is switched on
c     orbitals are no orthogonalized since they represent large
c     components of the corresponding Dirac-Fock orbitals
      
 99   if(irel.eq.0) call orthog
      return
      end
