*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The results of the previous calculations still in memory are
*     scaled to form initail estimates for another case
*
*****
      subroutine scale(zz)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-wave.inc'

c      common /temp/ratio,sr,sc,ss,f0,f1,f2,f3,pnorm,theta,k,ixxy1(3300)

      dimension rs(maxno),ps(maxno)
      equivalence (rs(1),yr(1)),(ps(1),x(1))

c     *****  scale values of r=rs, p=ps and one-electron parameters.
c     *****  generate new values of r, r*r, and sqrt(r)


      if(z.eq.zz) go to 14
      ratio = z/zz
      sr = sqrt(ratio)
      do j = 1,no
         r(j) = r(j)*ratio
         rr(j) = r(j)*r(j)
         r2(j) = r2(j)*sr
      enddo

      z=zz
      return


14    continue
      do i = 1,nwf
         if(z.eq.zz) go to 12
         sc = (zz-s(i))/(z-s(i))
         ss = sc*ratio
         e(i,i) = e(i,i)*sc**2
         do j = 1,no
            rs(j) = r(j)/ss
            ps(j) = p(i,j)*sc
         enddo
         sc = (zz - d5*s(i))/(z - d5*s(i))
         az(i) = az(i)*sc**(l(i)+1)*sqrt(sc)
         k = 3

c        *****  interpolate the (rs,ps) functions for values of p at the set
c        *****  of points r

         do j = 1,no

c           *****  search for the nearest entries in the (rs,ps) table
            
 5          if (k .eq. nd) go to 7
            if (rs(k) .gt. r(j)) go to 6
            k = k + 1
            go to 5

c           *****  interpolate

 6          theta = log(r(j)/rs(k-1))/h
            f0 = ps(k-2)
            f1 = ps(k-1)
            f2 = ps(k)
            f3 = ps(k+1)
            p(i,j) = d5*(f1+f2) + (theta -d5)*(f2 - f1) +
     1           theta*(theta - d1)*(f0 - f1 - f2 + f3)/d4
            go to 4
 7          p(i,j) = d0
 4          continue
         enddo
         maxv(i) = no
         
c        ***** normalize the interpolated function

         pnorm = sqrt(quadr(i,i,izero))
         do j = 1,no
            p(i,j) = p(i,j)/pnorm
         enddo

c        *****  compute new values of y0(i,i) and store
         
 12      continue
         call ykf(i,i,izero)
         do j = 1,no
            y(i,j) = yk(j)
         enddo
      enddo
      z = zz

      return
      end
