*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The rotate subroutine rotates orbitals connected through
*     orthogonality
*
*****
      subroutine rotate(i,j)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-coeff.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-rotorb.inc'
      include 'common-state.inc'
      include 'common-wave.inc'

      g = d0
      dg = d0
      if (qi .eq. d2*(2*l(i)+1) .and. qj .eq. d2*(2*l(j)+1))
     1   go to 44
      if (abs(qi - qj) .lt. 1.d-14) go to 16
      c = d5*(qi - qj)
      g = g-c*hl(i,j)
      dg = dg-c*(hl(i,i)-hl(j,j))

 16   do k = 1,5
         c = qi*(a(i,i,k) - a(i,j,k) - b(i,j,k))
         if (abs(c) .lt. 1.d-10) go to 21
         g = g + c*rk(i,i,i,j,2*(k-1))
         fkii = fk(i,i,2*(k-1))
         fkij = fk(i,j,2*(k-1))
         gkij = gk(i,j,2*(k-1))
         dg = dg + c*(fkii -fkij - d2*gkij)
 21      cj = qj*(a(j,j,k) - a(j,i,k) - b(j,i,k))
         if (abs(cj) .lt. 1.d-10) go to 13
         fkjj = fk(j,j,2*(k-1))
         if (abs(c) .ge. 1.d-10) go to 22
         fkij = fk(i,j,2*(k-1))
         gkij = gk(i,j,2*(k-1))
 22      g = g - cj*rk(j,j,j,i,2*(k-1))
         dg =dg + cj*(fkjj - fkij - d2*gkij)
 13      continue
      enddo

      do m = 1,nwf
         if (m .eq. i .or. m.eq. j) go to 14
         do k = 1,5
            c = a(i,m,k)*qi - a(j,m,k)*qj
            if (abs(c) .lt. 1.d-10) go to 23
            g = g + c*rk(i,m,j,m,2*(k-1))
            dg = dg + c*(fk(i,m,2*(k-1)) - fk(j,m,2*(k-1)))
 23         c = b(i,m,k)*qi - b(j,m,k)*qj
            if (abs(c) .lt. 1.d-10) go to 15
            kk = abs(l(i) - l(m)) + 2*(k-1)
            g = g+c*rk(i,j,m,m,kk)
            dg = dg + c*(gk(i,m,kk) - gk(j,m,kk))
 15         continue
         enddo
 14      continue
      enddo

c     *****  add contribution from the interaction of configurations

      if (nr .eq. 0) go to 11
      do ii = 1,nr
         n1 = ncri(ii)
         n2 = ncrj(ii)
         c = wt(n1)*wt(n2)*cr(ii)
         call rpert(i,j,ii)
         if (.not. ezero ) go to 45
         g =g + d5*c*(di - dj)
         dg = dg + d5*c*(dij -djj -dii + dji)
      enddo

c     ***** add contributions from the interaction of configurations - hl

 11   if (nl .eq. 0) go to 101
      do ii = 1,nl
         n1 = ncli(ii)
         n2 = nclj(ii)
         c = wt(n1)*wt(n2)*cl(ii)
         call lpert(i,j,ii)
         if (.not. ezero ) go to 45
         g = g + d5*c*(di -dj)
         dg = dg + d5*c*(dij - djj - dii + dji)
      enddo

 101  write (ouc,100) g,dg
 100  format(10x,12hcondition = ,f10.6,4x,12hvariation = ,f10.6)
 1    if (abs(g) .gt. 1.d-9 .or. abs(e(i,j)) .gt. 2.d-10) go to 40
      g = d0
 44   e(i,j) = d0
      return

40    continue
      ezero = .false.
      return

c     ***** one of the pair of orbitals occurs in an overlap integral and
c     ***** the pair cannot be rotated

 45   g = d0

      return
      end
