*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The rinputd subroutine processes input data
*
*****
      subroutine rinputd (acfg,scftol,cfgtol,print,new)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      character*8 clabel, atmp
      
      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

      dimension idtmp(100)

 500  continue
      ilabel=ilabel+1
      ilf=0

      call cardc(ione)
      call inpa(clabel)
      call lowcase(clabel,8)

      if (clabel.eq.'inout') then
         ilf=1
         if (iatom.eq.1) then
            write(*,2000)
 2000       format('Error: wrong order of input data cards')
            stop 'main'
         endif
         
c        Read unit numbers for input and output files containing initial
c        and final orbitals, respectively. Two additional optional
c        values can be used to obtain F and G integrals (oud) and energy
c        matrix (ouh). By default oud=ouh=0
         
c        If inf/ouf is set to zero no orbitals are read/written.
         
         
         call inpi(iuf)
         call inpi(ouf)
         call inpi(itmp)
         if (itmp.ne.inpiexit) then
            oud=itmp
            call inpi(itmp)
            if (itmp.ne.inpiexit) then
               ouh=itmp
            endif
         endif
      endif

      if (clabel.eq.'out2dhf') then
         ilf=1

c        If unit number ouf2dhf is non-zero configuration information and
c        final orbitals are written in a format suitable for 2D HF program
         
         ouf2dhf=0
         call inpi(ouf2dhf)
      endif

      
c     read 'grid' card
      if (clabel.eq.'grid') then
         ilf=1
c        recalculate grid parameters
         call setgrid(ione)
c        ib = nwf - nit + 1
         nd = no - 2
      endif
      
      
      if (clabel.eq.'atom') then
         ilf=1
         if (iatom.eq.2) then
            write(*,2000)
            stop 'main'
         endif
         iatom=1
c           read 'atom', 'electron' and 'integral' cards            
            call data(new)
         endif

c        read 'scf' card
         if (clabel.eq.'scf') then
            ilf=1
            call inpi(itmp)
            if (itmp.ne.inpiexit) then
               nsigdig=itmp
               scftol=10.d0**nsigdig
               call inpi(itmp)
               if (itmp.ne.inpiexit) then
                  nscf=itmp
                  call inpa(clabel)
                  call lowcase(clabel,8)
                  if     (clabel.eq.'f') then
                     omit=.false.
                  elseif (clabel.eq.'t') then
                     omit=.true.
                  endif
               endif
            endif
         endif

c        read 'mcscf' card
         if (clabel.eq.'mcscf') then
            ilf=1
            call inpi(itmp)
            if (itmp.ne.inpiexit) then
               nsigdig=itmp
               cfgtol=10.d0**nsigdig
               call inpf(ftmp)
                if (ftmp.ne.0.d0) then
                   acfg=ftmp
                   call inpa(clabel)
                   call lowcase(clabel,8)
                   if     (clabel.eq.'f') then
                      ld=.false.
                   elseif (clabel.eq.'t') then
                      ld=.true.
                   else
                      goto 500 
                   endif
                   call inpa(clabel)
                   call lowcase(clabel,8)
                   if     (clabel.eq.'f') then
                      ortho=.false.
                   elseif (clabel.eq.'t') then
                      ortho=.true.
                   else 
                      goto 500
                   endif
                   call inpi(itmp)
                   if (itmp.ne.inpiexit) then
                      new=itmp
                   endif
                endif
            endif
         endif


        if (clabel.eq.'alpha') then
            call inpf(ftmp)
            if (ftmp.ne.0.d0) then
               xalpha=ftmp
            endif
            ilf=1
        endif

        if (clabel.eq.'gauss') then
            call inpf(ftmp)
            if (ftmp.ne.0.d0) then
               izz1=nint(z)
               atweight(izz1)=ftmp
            endif
            ilf=1
            igauss=1

        endif

        if (clabel.eq.'fermi') then
            ilf=1
            ifermi=1
            call inpf(ftmp)
            if (ftmp.ne.0.d0) then
               izz1=nint(z)
               atweight(izz1)=ftmp
            endif
        endif

c        read 'rel' and 'qpot' card defining the type of a
c        quasirelativistic correction

        if (clabel.eq.'xpot') then
            ilf=1
           call dataxpot()
        endif

        if (clabel.eq.'qpot') then
            ilf=1
           call dataqrpot()
        endif

        if (clabel.eq.'rel') then
            ilf=1
           call datarel()
c           next=2
        endif

        if (clabel.eq.'print') then
           ilf=1
           print=.true.
        endif


c       read 'debug' card 
        if (clabel.eq.'debug') then
           ilf=1
           inzero=0
           do i=1,100
              call inpi(idtmp(i))
              if (idtmp(i).gt.0) then
                 inzero=inzero+1
                 idbg(idtmp(i))=1
              endif
           enddo
        endif

c     next = -1 stop
c     next =  0 continue: another case with new initial functions
c     next =  1 continue: a new case with scaled orbitals as a source of initial functions
c     next =  2 continue a previous case with (some of) relativistic parameters changed 

        if (clabel.eq.'cont') then
            ilf=1
           call inpa(atmp)
           if (atmp.eq.'new') then
              next=0
           endif

           if (atmp.eq.'scaled') then
              next=1
           endif

           if (atmp.eq.'rel') then
              next=2
           endif
           return
        endif

        if (clabel.eq.'stop'.or.clabel.eq.'end') then
           ilf=1
           next=-1
           return
        endif
        
        if (ilf.eq.0) then
           write(*,*) 'Error: unknown label found'
           call prtlabel
           stop 'main'
        endif
        if (ilabel.lt.1000) goto 500

      return
      end
