*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     This routine calculates the potential function to be used in a
*     quasirelativistic correction, its asymptotic form near the origin
*     and the QR correction itself.
*
*****
      subroutine relpot(i)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)

      include 'common.inc'
      include 'common-rel.inc'

c     The potential used in a quasirelativistic correction consists of
c     the nuclear, the Coulomb and the local exchange (Slater) potentials 

      call ykdft(i)

c     The quasirelativistic potential modifies solutions of the Fock
c     equations. Its asymptotic behaviour near the origin is needed to
c     provide correct staring values for the solutions. It has also to
c     be acounted for when evaluating integrals since integration over
c     [0..rho] region is treated analytically.
      
      call gencoeff(i)

      go to (10,20,30,40),iqpot
      
c     Cowan-Griffin correction
10    call qpotcg(i)
      return

c     Wood-Boring correction
20    call qpotwb(i)
      return

c     Barthelat et al. correction
30    call qpotbpd(i)
      return

c     Karwowski-Klobukowski correction
40    call qpotkk(i)
      return

      return
      end
