*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     quads integrates p(i)*p(j)*yk/r**kk by simpson's rule
*
*****
      real*8 function quads(i,j,kk)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'

      den=dlr(i)+dlr(j)+d3
      k = 2 - kk
      cd=d1+(zrl(i)/(dlr(i)+d1)+zrl(j)/(dlr(j)+d1))*r(1)/(den+d1)
      d = yk(1)*p(i,1)*p(j,1)*r(1)**k*( cd/(den*h1)+ d5)
      mx = mmin(maxv(i),maxv(j)) - 1
      do m = 2,mx,2
         d = d + d2*yk(m)*p(i,m)*p(j,m)*r(m)**k +
     1        yk(m+1)*p(i,m+1)*p(j,m+1)*r(m+1)**k
      enddo 
      quads = d*h1

      return
      end
