*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     This is the main subroutine of the QuasiRelativistic HF program
*
*****
      program qrhf
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      external scale  
      character*8 clabel, atmp
      
      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

c      dimension idtmp(100)

      call setparams


      write(ouc,55)
 55   format(//,'*****'/,'***** Quasirelativistic Hartree-Fock ',
     &          'method for atoms'/,
     &          '*****',13x,'(ver. 1.0, 2012)'/,
     &          '*****'/)

c     process input data defining the first case

      icase=0

c     'cont new' starts here
 100  continue

c     initialize various constants and variables 
      call init
      fail=.false.
      
c set defaults values of scftol and nscf     
      tol=toldef
      scftol=scftoldef
      nscf=maxnscf
      omit=.true.

c set defaults values of cfgtol and acfg (accelerating parameter)
      cfgtol=cfgtoldef
      acfg=acfgdef
      ld=.true.
      ortho=.false.
      print=.false.

      ic=0

c     by default no relativistic corrections are included
      irel=0

c     set default values of the grid
      call setgrid(izero)

      iatom=0
      ilabel=0
 500  continue

      call casesep(icase)

c     read input data
      call rinputd(acfg,scftol,cfgtol,print,new)

      scftolcurr=scftol
      cfgtolcurr=cfgtol

      if (irel.eq.0) then
         if (igauss.ne.0) then
            izz1=nint(z)
            write(ouc,56) atweight(izz1) 
 56         format(/9x,"finite nucleus: Gauss nuclear charge ",
     &           "distribution"/,25x, "atomic mass = ",d16.10)
         elseif (ifermi.ne.0) then
            izz1=nint(z)
            write(ouc,57) atweight(izz1) 
 57         format(/9x,"finite nucleus: Fermi nuclear charge ",
     &           "distribution"/,25x, "atomic mass = ",d16.10)
            stop "Error: Fermi model is not supported"
         endif
      endif

 501  continue

      if (irel.eq.0) then
         do j=1,no
            vrel(j)=0.d0
         enddo
      endif

c     initialize orbitals
      if (iatom.ne.2) then
         do i=1,nwf
            dlr(i)=l(i)
         enddo
         
         if ( nit .ne. 0 ) call array
         call wavefn
      endif

c     perform mchf iterations

 502  continue

      cfgtol=cfgtolcurr
      scftol=scftolcurr

      call scf(etotal,acfg,scftol,cfgtol,ld,new)

      if(fail) go to 600

c     output wafe functions if print = .true.
      if(indmc.eq.1) go to 334
      if(indmc.eq.2.and.ib.gt.nwf) go to 334

      if(ib.gt.nwf) go to 600
334   continue

      call output(print)
      call summry(etotal)

 600  continue
      if (next.eq.-1) stop

      goto (100,150,200),next+1

 150  continue

c     'cont scaled' starts here
c     scale results for another member of the isoelectronic sequence
c     read only 'atom' card to get the new value of Z

c     read 'atom' card
      call cardc(ione)

c     skip 'atom' label
      call inpa(clabel)
      call inpa(clabel)
      atom=clabel
      call inpa(clabel)
      term=clabel
      call inpf(zz)
      z=zz
c     remaining input data can be retrieved as usual
      call rinputd(acfg,scftol,cfgtol,print,new)

c      call setgridcont
c      iuf=0
      iatom=2
      call casesep(icase)
      goto 502

      do i=1,nwf
         acc(i)=0.d0
      enddo

      call scale(zz)

      write (ouc,2) atom,term,zz
2     format(/9x,42hHartree-Fock (scaled) wave functions for   ,2a6,
     1           4h Z =,f5.1/)

      if( zz.ne.z.and.irel.eq.0) call orthog
      iatom=2
      go to 500

 200  continue
      iatom=2
      if ( reldamp.ne.d1 ) then
         reldamp=reldamp/reldampsf
         if (reldamp.le.1.05d0) then 
            reldamp=d1
         endif
         cveldamp=reldamp*cvel
         fsc=d1/cveldamp
         fsc2=fsc*fsc
         call casesep(icase)
         call relmesg
         goto 502
      else
         call rinputd(acfg,scftol,cfgtol,print,new)
         if (next.eq.-1) then
            stop
         else
            call casesep(icase)
            goto 501 
         endif
      endif
      
      stop
      end




