*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     This routine calculates a quasirelativistic correction due to
*     Barthelat, Pelissier and Durand (Phys. Rev. A21, 1773 (1980))
* 
****
      subroutine qpotbpd(i)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-state.inc'
      include 'common-wave.inc'

      dimension a(maxno),ar(maxno)

      if (iqpot.ne.3) then
         write(*,*) 'Error: incorrect qusirelativistic potential'
         stop 'qpotbpd'
      endif

      zt=zvar(i)
      ee=-d5*e(i,i)

      if     (iupd.eq. 0) then
         xk=-d1
      elseif (iupd.eq. 1) then
         xk=-l(i)-d1
      elseif (iupd.eq.-1) then
         xk=l(i)
      endif

54    if(qc(i,1).eq.d4*l(i)+d2.and.l(i).ne.0) then
         xx=l(i)*l(i)*(d1-sqrt(d1-fsc2*zt*zt/(l(i)*l(i))))
     1    -(l(i)+1)**2*(d1-sqrt(d1-fsc2*zt*zt/(l(i)+1)**2))
         xx=xx/(d2*l(i)+d1)
         xk=d1
      endif

      if(l(i).eq.0)  xk=-d1

      xx=d1-sqrt(d1-fsc2*zt*zt/(xk*xk))

      do j=1,no
         a(j)=vxch(j)/r2(j)
      enddo
      call diffs(a,ar,ione)

      do j=1,no
         ar(j)=(ar(j)+d5*a(j))/r2(j)
      enddo 

      do j=1,no
         vrel(j)=-d5*fsc2*((ee-vxch(j))**2+xx*ar(j)*xk/(zt*fsc2))
      enddo 

      q0(i)=(zt*z1-ee*ee*d5)*fsc2-d5*xk*xx*z1/zt
      qm1(i)=-ee*zt*fsc2
      qm2(i)=-d5*(zt*zt*fsc2+xk*xx)

      zrl(i)=zt-qm1(i)
      ax=(l(i)+d5)*(l(i)+d5)+d2*qm2(i)
      if(ax.gt.0d0) then 
         dlr(i)=-d5+sqrt(ax)
      else
         dlr(i)=-d5
      endif

      if(idbg(30).ne.0) then
         write(ouc,*) 'qpotbb'
         write(ouc,*) 'qm2,qm1,qm0',qm2(i),qm1(i),q0(i)
         write(ouc,*) 'zrl,dlr',zrl(i),dlr(i)
      endif		 

      return
      end
