*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The potllda subroutine fills for orbital i the vdft array with the
*     values of the Slater local exchange potential. It is assumed that
*     only one configuration contributes to the total density and that
*     the number of electrons with up and down spin matches
*
*****
      subroutine potllda(i)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      parameter (const13=1.d0/3.d0,const23=2.d0/3.d0,const34=3.d0/4.d0)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-state.inc'

      qccp=d2
      if (qc(i,1).lt.qccp) qccp=qc(i,1)

c     fdftpot=-xalpha*three/two*(three/pii)**const13/two**(const23)
      fdftpot=-xalpha*three/two*(three/pii)**const13
      do k=1,no
         rhot=d0
         do j=1,nwf
            qcc=qc(j,1)
            rhot=rhot+qcc*p(j,k)**2
         enddo
         rhotp=rhot-qccp*p(i,k)**2

         vdft(k)=fdftpot*rhotp**const13
      enddo
      return
      end
