*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     potl computes the potential function yr for the ith orbital
*
*****
      subroutine potl(i)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-coeff.inc'
      include 'common-param.inc'

      do j=1,no
         yr(j)=d0
      enddo

      do j=1,nwf
         c = a(i,j,1)
         if(abs(c) .le. 1.d-10) go to 2
         do jj = 1,no
            yr(jj) = c*y(j,jj) + yr(jj)
         enddo
 4       do k = 2,5
            c = a(i,j,k)
            if (abs(c) .lt. 1.d-20) go to 5
            call ykf(j,j,itwo*k-itwo)
            do jj=1,no
               yr(jj) = yr(jj) + c*yk(jj)
            enddo
 5          continue
         enddo
 2       continue
      enddo

      return
      end
