*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The orthog performs the Schmidt orthogonalization of orbitals
*
*****
      subroutine orthog
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-coeff.inc'
      include 'common-param.inc'
      include 'common-rotorb.inc'
      include 'common-wave.inc'
 
      dimension ki(4),kj(4),kt(4)
      equivalence (i1,ki(1)),(i2,ki(2)),(j1,kj(1)),(j2,kj(2))

      if (nwf .eq. 1 .or. ib .gt. nwf) return
      write(ouc,26)
26     format(/)
      ii = mmax(itwo,ib)
      do i = ii,nwf
         il = i-1
         do j = 1,il
            if (n(i) .eq. n(j) .or. l(i) .ne. l(j)) go to 3
            if (a(i,j,1) .eq. d0 .and. .not. ortho) go to 3
            kj(1) = j
            nj = 1
            if (.not. ortho) go to 9

c           *****  an (i,j) pair constrained by an orthogonality requirement has
c           *****  been found.  check if another orbital with index > j has the
c           *****  same nl value.

            if ( j .eq. il ) go to 1
            other = .false.
            jp = j+1
            do j2 = jp,il
               if (n(j2) .eq. n(j) .and. l(j2) .eq. l(j)) 
     &              other = .true.
            enddo
            if (other) go to 3
            
c           *****  the (i,j) pair has the highest possible indices for the given
c           *****  set of nl values
c           *****  search for other orbitals with the same nl values
            
 1          if ( j .eq. 1 ) go to 8
            jm = j-1
            
            do k = 1,jm
               if (n(k) .ne. n(j) .or. l(k) .ne. l(j)) go to 7
               nj = nj + 1
               kj(nj) = k
 7             continue
            enddo
            
 8          if (nj .eq. 1.or.irel.ne.0)  go to 9
            ov = quadr(j1,j2,izero)
            c1 = quadr(i,j1,izero)
            c2 = quadr(i,j2,izero)
            den = d1 - ov**2
            a1 = -(c1 - c2*ov)/den
            a2 = -(c2 - c1*ov)/den
            write(ouc,6) el(i),el(j1), c1,el(i),el(j2),c2,
     &           el(j1),el(j2),ov
            d = sqrt(d1 + c1*a1 + c2*a2)
            mx = mmax3(maxv(i),maxv(j1),maxv(j2))

            do jj = 1,mx
               p(i,jj) = (p(i,jj) + a1*p(j1,jj) + a2*p(j2,jj))/d
            enddo
            
            az(i) = (az(i) + a1*az(j1) + a2*az(j2))/d
            go to 35

 9          d = quadr(i,j,izero)
            if(irel.ne.0) go to 99
            if ( abs(d) .lt. 1.d-9 ) go to 3
            di = sqrt(d1 - d*d)
            if (p(i,1)-d*p(j,1) .lt. d0) di = -di
            imax = maxv(i)
            jmax = maxv(j)
            mx = mmax(imax,jmax)
            do k=1,mx
               p(i,k) = (p(i,k) - d *p(j,k))/di
            enddo
            az(i) = (az(i) - d*az(j))/di
 99         write(ouc,6) el(i),el(j),d
 6          format(10x,'<',a3,'|',a3,'> = ',1pd13.3)
            
            if(irel.ne.0) go to 3

c           *****  compute and store y0(i,i)

 35         call ykf(i,i,izero)
            do k = 1,no
               y(i,k) = yk(k)
            enddo
 3          continue
         enddo
 2       continue
      enddo
      return
      end
