*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*	The output subroutine prints the set of functions P_i(r)
*	involved in the SCF iterations. These functions together with r
*	values and some additional parameters may also be written into a
*	separate file for later use by the 2DHF program
*
*****
      subroutine nuclder
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-state.inc'
      include 'common-wave.inc'
      include 'common-rel.inc'

      dimension dender(10),pbar(maxno),pbarprim(maxno)
      stop
      print *,""
      do i=1,nwf
         print *,""
c         pn = hnorm(n(i),l(i),z)

         izero=0
C$$$         rm  = quadr(i,i,izero)
C$$$         print *,i,rm

         do j=1,no
            pbar(j)=p(i,j)
         enddo

         call genOrbCoeff(i)

         stop

         call diffs(pbar,pbarprim,ione)

         do k=1,10
            pt=pbar(k)*r2(k)
            ptprim=(d5*pbar(k)+pbarprim(k))/r2(k)

            dender(k)=2.d0*pt*(ptprim-pt/r(k))/rr(k)
            write(*,'(i4,5d20.12)') k,r(k),pt,dender(k),
     &           dender(k)/(pbar(1)*pbar(1)/r(1))
         enddo
         write(*,'(3d20.12)') rho,r(1),erf(r(1))

         do k=1,9
            pt1=pbar(k)*r2(k)
            pt2=pbar(k+1)*r2(k+1)
            ptprim=(pt2-pt1)/(r(k+1)-r(k))
            write(*,'(i4,4d20.12)') k,ptprim
         enddo

         print *,""
         do k=1,9
            pt1=pbar(k)/r2(k)
            pt1=pt1*pt1
            pt2=pbar(k+1)/r2(k+1)
            pt2=pt2*pt2
            ptprim=(pt2-pt1)/(r(k+1)-r(k))
            write(*,'(i4,4d20.12)') k,ptprim
         enddo

         print *,""
         do k=1,9
            pt1=pbar(k)/r2(k)
            pt2=pbar(k+1)/r2(k+1)
            ptprim=2.d0*pt1*(pt2-pt1)/(r(k+1)-r(k))
            write(*,'(i4,4d40.30)') k,r2(k),pbar(k),pbar(k)/r2(k),ptprim
         enddo




C$$$         do k=1,10
C$$$            pt=pbar(k)*r2(k)
C$$$            ptprim=(d5*pbar(k)+pbarprim(k))/r2(k)

C$$$            dender(k)=2.d0*pt*(ptprim-pt/r(k))/rr(k)
C$$$            write(*,'(i4,4d20.12)') k,pt,dender(k),
C$$$     &           dender(k)/(pbar(1)*pbar(1)/r(1))
C$$$         enddo
C$$$         write(*,'(3d20.12)') rho,r(1),erf(r(1))

C$$$         do k=1,9
C$$$            pt1=pbar(k)*r2(k)
C$$$            pt2=pbar(k+1)*r2(k+1)
C$$$            ptprim=(pt2-pt1)/(r(k+1)-r(k))
C$$$            write(*,'(i4,4d20.12)') k,ptprim
C$$$         enddo

C$$$         print *,""
C$$$         do k=1,9
C$$$            pt1=pbar(k)/r2(k)
C$$$            pt1=pt1*pt1
C$$$            pt2=pbar(k+1)/r2(k+1)
C$$$            pt2=pt2*pt2
C$$$            ptprim=(pt2-pt1)/(r(k+1)-r(k))
C$$$            write(*,'(i4,4d20.12)') k,ptprim
C$$$         enddo


         
C$$$         do k=1,10
C$$$            dender(k)=2.d0*pbar(k)*(pbarprim(k)-d5*pbar(k))/rr(k)
C$$$            print *,k,dender(k)/(pbar(1)*pbar(1)/r(1))
C$$$         enddo

      enddo


      return
      end

*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The quasirelativistic potential modifies solutions of the Fock
*     equations (orbitals and potentials). Its asymptotic behaviour near
*     the origin is needed to provide correct starting values for the
*     solutions. But this behaviour is determined by the asymptotic
*     behaviour of the Coulomb and local exchange potentials (used in
*     the correction). 

*     We assume that the asymptotic behaviour is of the form:

*     V_C -V_{lx} = z_1 r +  z_2 r^2 + z_3 r^3

*     z_1 parameter is used to modify the starting values of orbitals
*     (see solve and start). It is also used by quadr when evaluating
*     the [0..rho] part of the integral.
*
*****
      subroutine genOrbCoeff(iorb)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

c     this declaration is necessary for quadruple version to work properly
c     (it seems that the implicit declaration does not suffice)

      integer*4 lda,ma,na,lwork

      parameter (lda=8,ma=8,na=8,lwork=200)
      dimension a(lda,ma),b(lda,1),work(lwork)
      dimension dender(10),pbar(maxno),pbarprim(maxno)

      do i=1,no
         pbar(i)=p(iorb,i)/r2(i)
      enddo

      write(ouc,*) "iorb,dlr(iorb)", iorb,dlr(iorb)

      do i=1,ma
         rc=r(i)**dlr(iorb)
         do j=1,na
            a(i,j)=rc
            write(ouc,'(i2,3d25.12)') i,j,pbar(i),rc
            rc=rc*r(i)
         enddo
         b(i,1)=pbar(i)
      enddo

c     LAPACK routines are used to solve the system of linear equations
      lwork=10*ma*na
      call dgels('N',ma,na,ione,a,lda,b,lda,work,lwork,info)

      z1=b(1,1)

      if (info.ne.0) then
         write(*,'("Error: DGELS returns with INFO =",i3)') info
         stop 'genOrbCoeff'
      endif

      idbg(10)=0
      if(idbg(10).ne.0)  then
         write(ouc,*) 'genOrbCoeff: dgels'
         write(ouc,*) 'b(1,1),b(2,1),b(3,1)',b(1,1),b(2,1),b(3,1)
         write(ouc,*) 'checking accuracy of solution: x Ax (Ax-b)/b'
         do i=1,ma
            pp=r(i)**dlr(iorb)*(b(1,1)+b(2,1)*r(i)+b(3,1)*rr(i))
            write(ouc,'(d12.6, 3d20.12)') r(i),pp,pbar(i),
     &           (pp/pbar(i)-1d0)
         enddo

         p0=b(1,1)
         pn0=b(2,1)*r(1)/b(1,1)
         p1=(dlr(iorb)+one)*b(2,1)

         write(ouc,*) "p0,p1,2R dR/dr ",p0,p1,2.d0*p0*p1

         stop 'genOrbCoeff'
      endif	

      return
      end
