*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The nmrvs subroutine integrates the equation Y''=F(r)Y+G(r)
*     outward nj steps by the Numerov method, then applies a tail
*     procedure for a solution
*
*****
      subroutine nmrvs(nj,delta,mm,pde,f)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      dimension pde(*),f(*),a(maxno),d(maxno)

      equivalence (g,g3)

c  *****  integrate outward to nj+1

      y1 = pde(1)
      y2= pde(2)
      g1 = yr(1)
      g2 = yr(2)
      m = nj + 1
      do i = 3,m
         g3 = yr(i)
         y3 = (y2+y2-y1 + (d10*g2*y2 + g1*y1) + f(i-1)) / (d1 - g3)
         pde(i) = y3
         y1 = y2
         y2 = y3
         g1 = g2
         g2 = g3
      enddo 
      delta = y3

c     *****  apply the tail procedure

      k = 1
      pde(m) = -(d1 - g1)*y1 + f(m)

      a(1) = d1 - g
      d(1) = -(d2 + d10*g)
 22   ratio = a(k)/d(k)

c     if (k .ge. 149 .or. m .eq. nd) go to 23
c     8/04/05 hardcoded limitations lifted

      if (k .ge. nd .or. m .eq. nd) go to 23
      k = k +1
      m = m+1
      g = yr(m)
      a(k) = d1 - g
      d(k) = -(d2 + d10*g) - a(k)*ratio
      pde(m) = -pde(m-1)*ratio + f(m)

      if (abs(pde(m))+abs(pde(m-1)) .gt. tol .or. k .lt. 9) go to 22

20    con =sqrt(eh)*exp(-sqrt(abs(g/ch-0.25d0)/rr(m))*(r(m+1)-r(m)))

      pde(m) = pde(m)/(d(k) + con*(d1-	yr(m+1)))
      j = m+1
      do i= j,no
         pde(i) = d0
      enddo 

      do j = 2,k
         i = m-j+1
         ii = k-j+1
         pde(i) = (pde(i)-a(ii+1)*pde(i+1))/d(ii)
      enddo 
        
c     *****  set delta = difference of the two solutions at nj+1
c     *****  mm = number of points in the range of the solution

      delta = delta - pde(i)
      mm = m

      return

23    write (ouc,24)
24    format(6x,52hwarning: functions truncated by nmrvs in tail region)

      go to 20
      end
