*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     This subroutine initializes various constants and variables
*
*****
      subroutine init
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-coeff.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

c     set velocity of light, pi, etc
      call setconst

      cfgtol=0.d0
      scftol=0.d0

c     set commonly used real*8 constants

      d0=0.d0
      d1=1.d0
      d2=2.d0
      d3=3.d0
      d4=4.d0
      d5=1.d0/2.d0
      d6=6.d0
      d8=8.d0
      d10=10.d0
      d12=12.d0
      d16=16.d0
      d30=30.d0

c   *****   clear the arrays for the average interactions

      do i=1,4
         do j=1,4
            ca(i,j)=d0
         enddo 
      enddo

      do i=1,5
         do j=1,5
            do k=1,5
               cb(i,j,k)=d0
            enddo 
         enddo 
      enddo 

c   *****   average interactions for equivalent electrons

c   *****   p  -  p

      ca(1,1)=2.d0/25.d0

c   *****   d  -  d

      ca(2,1)=2.d0/63.d0
      ca(2,2)=2.d0/63.d0

c   *****   f  -  f

      ca(3,1)=	4.d0/195.d0
      ca(3,2)=	2.d0/143.d0
      ca(3,3)=100.d0/5577.d0

c   *****   g  -  g

      ca(4,1)=	20.d0/	1309.d0
      ca(4,2)= 162.d0/ 17017.d0
      ca(4,3)=	20.d0/	2431.d0
      ca(4,4)=4410.d0/371943.d0

c   *****   average interactions for non-equivalent electrons

c   *****   s  -  ( s, p, d, f, g )

      cb(1,1,1)=1.d0/2.d0
      cb(2,1,1)=1.d0/6.d0
      cb(3,1,1)=1.d0/10.d0
      cb(4,1,1)=1.d0/14.d0
      cb(5,1,1)=1.d0/18.d0

c   *****   p  -  ( p, d, f, g )

      cb(2,2,1)=1.d0/6.d0
      cb(2,2,2)=1.d0/15.d0
      cb(3,2,1)=1.d0/15.d0
      cb(3,2,2)=3.d0/70.d0
      cb(4,2,1)=3.d0/70.d0
      cb(4,2,2)=2.d0/63.d0
      cb(5,2,1)=2.d0/63.d0
      cb(5,2,2)=5.d0/198.d0

c   *****   d  -  ( d, f, g )

      cb(3,3,1)=1.d0/10.d0
      cb(3,3,2)=1.d0/35.d0
      cb(3,3,3)=1.d0/35.d0
      cb(4,3,1)=3.d0/70.d0
      cb(4,3,2)=2.d0/105.d0
      cb(4,3,3)=5.d0/231.d0
      cb(5,3,1)=1.d0/35.d0
      cb(5,3,2)=10.d0/693.d0
      cb(5,3,3)=5.d0/286.d0

c   *****   f  -  ( f, g )

      cb(4,4,1)=1.d0/14.d0
      cb(4,4,2)=2.d0/105.d0
      cb(4,4,3)=1.d0/77.d0
      cb(4,4,4)=50.d0/3003.d0
      cb(5,4,1)=2.d0/63.d0
      cb(5,4,2)=1.d0/77.d0
      cb(5,4,3)=10.d0/1001.d0
      cb(5,4,4)=35.d0/2574.d0

c   *****   g  -  ( g )

      cb(5,5,1)=1.d0/18.d0
      cb(5,5,2)=10.d0/693.d0
      cb(5,5,3)=9.d0/1001.d0
      cb(5,5,4)=10.d0/1287.d0
      cb(5,5,5)=245.d0/21879.d0

c   *****   symmetrize the array

      do i=2,5
         im=i-1
         do j=1,im
            do k=1,4
               cb(j,i,k)=cb(i,j,k)
            enddo 
         enddo 
      enddo 

c     moved from main
      do i=1,20
         dpm(i)=d10
         do j=1,20
            if(i.ne.j) e(i,j)=1.d-10
         enddo
      enddo

      do i=1,100
         idbg(i)=0
      enddo

      return
      end


      include 'blk-data.inc'
