*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     hwf computes a value for an unnormalized hydrogenic function
*
*****
      real*8 function hwf(nn,ll,zz,rt)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'

      k = nn-ll-1
      pp = d1
      a = d1
      b = k
      c = nn+ ll
      xx = -d2*zz*rt/nn
c
c  *****  test if underflow may occur, if so set hwf = 0
c
      if ( xx .lt. -180.d0 ) go to 5
      if (k) 1,2,3
3     do i = 1,k
         pp = d1 + a/b*pp/c*xx
         a = a + d1
         b = b - d1
         c = c - d1
      enddo

2     hwf = pp*exp(xx/d2)*(-xx)**(ll+1)
      return

1     write(ouc,7) nn,ll,zz,rt
    7  format(51h forbidden combination of n and l in hwf subprogram/
     1    4h n =,i4,6h   l = ,i4,6h   z = ,f6.1,6h   r = ,f8.4)
      stop
5     hwf = d0
      return
       end
