*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*	
*
*****
      real*8 function hl(i,j)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

      dimension dd(maxno)

      if(abs(l(i)-l(j)).ne. 0) then
         write(ouc,4) el(i),l(i),el(j),l(j)
 4       format(10x,'unallowed l values occurred in hl subroutine'/)
      endif

      mm=mmin3(maxv(i)+ifive,maxv(j)+ifive,nd-itwo)
      fl=l(i)
c     tz= z + z

      c=(fl+d5)**2
      hh=5040.d0*h*h

      do k=5,mm
         tz= two*zvar(k)
         yk(k)=(-9.d0*(p(i,k+4)+p(i,k-4))+128.d0*(p(i,k+3)+p(i,k-3))
     &        -1008.d0*(p(i,k+2)+p(i,k-2)) + 8064.d0*(p(i,k+1)+p(i,k-1))
     &        -14350.d0*p(i,k))/hh + p(i,k)*(tz*r(k) - c)
      enddo

      if(irel.ne.0) then
         do k=1,no
            dd(k)=yk(k)
         enddo
         
c        add a quasirelativistic correction to the potential function 

         call relpot(i)
         do k=1,no
            yk(k)=dd(k)
         enddo
         do k=5,mm
            yk(k)=yk(k)-d2*vrel(k)*rr(k)*p(i,k)
         enddo
      endif

      dli=dlr(i)
      dlj=dlr(j)
      zri=zrl(i)
      zrj=zrl(j)

      k=4
      inc=-1
      do jj=1,2
         do kk=1,5
            dd(kk)=yk(k-kk*inc)/r(k-kk*inc)**(dli+2.5d0)
         enddo
         dd1= dd(2)-dd(1)
         dd2=(dd(3)-d2*dd(2)+dd(1))/d2
         dd3=(dd(4)-d3*(dd(3)-dd(2))-dd(1))/d6
         dd4=(dd(5)-d4*(dd(4)+dd(2))+d6*dd(3)+dd(1))/24.d0
      enddo

      do kk=1,4
         yk(k+(kk-1)*inc)=(dd(1)-kk*(dd1-(kk+1)*(dd2-(kk+2)* 
     &        (dd3-(kk+3)*dd4))))*r(k+(kk-1)*inc)**(dli+2.5d0)
      enddo

      k=mm
      inc=1                      
      mm=mm+2
      den=dli+dlj+d3

      hl=0.d0
      if(irel.ne.0) then 
         fact=(zri/(dli+d1)+zrj/(dlj+d1))/(den+d1)
         hl=yk(1)*p(j,1)*((d1+r(1)*fact)/(den*h1)+d5)
      endif

      do m=2,mm,2
         hl=hl+d2*p(j,m)*yk(m)+p(j,m+1)*yk(m+1)             
      enddo
      hl=hl*h1           

      continue

      return
      end
