*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*	
*
*****
      real*8 function elagr(i,j)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-coeff.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-rotorb.inc'
      include 'common-state.inc'
      include 'common-wave.inc'

      qi=sum(i)
      qj=sum(j)
      ezero= .true.
      g=d0
      if (e(i,j) .eq. d0) go to 1
      all= .true.

      call rotate(i,j)
c
c   *****   if ezero is 'true', then the off-diagonal energy parameters
c   *****   should be zero
c
 12   if (ezero) go to 1
      if (.not. ezero .and. g .eq. d0) go to 1
      g=d0
      if(abs(qi-qj) .lt. 5.d-2) go to 1
c
c   *****   compute the off-diagonal energy parameter when both
c   *****   functions are in the scf iteration and qi not equal to qj
c
 16   do k=1,5
         c=a(i,i,k)-a(j,i,k)-b(j,i,k)
         if (abs(c    ) .gt. 1.d-10) g=g+    c*rk(i,i,i,j,itwo*(k-1))
         c=a(j,j,k)-a(i,j,k)-b(i,j,k)
         if (abs(c    ) .gt. 1.d-10) g=g-    c*rk(j,j,j,i,itwo*(k-1))
      enddo

      do m=1,nwf
         if (m .eq. i .or. m .eq. j) go to 14
         do k=1,5
            c=a(i,m,k)-a(j,m,k)
            if (abs(c) .gt. 1.d-10) g=g+c*rk(i,m,j,m,itwo*(k-1))
            c=b(i,m,k)-b(j,m,k)
            if (abs(c) .gt. 1.d-10) g=g+c*rk(i,j,m,m,abs(l(i)-l(m))
     1           +2*(k-1))
         enddo
 14      continue
      enddo

c   *****   add contribution from the interaction of configurations

      all= .false.
      if (nr .eq. 0) go to 11
      do ii=1,nr
         n1=ncri(ii)
         n2=ncrj(ii)
         c=wt(n1)*wt(n2)*cr(ii)
         ci=c/sum(i)
         cj=c/sum(j)
         call rpert(i,j,ii)
         dd=ci*di-cj*dj
         g=g+d5*dd
      enddo

c   *****   add contribution from the interaction of configurations-hl

 11   if (nl .eq. 0) go to 1
      do ii=1,nl
         n1=ncli(ii)
         n2=nclj(ii)
         c=wt(n1)*wt(n2)*cl(ii)
         ci=c/sum(i)
         cj=c/sum(j)
         call lpert(i,j,ii)
         dd=ci*di-cj*dj
         g=g+d5*dd
      enddo

 1    elagr=g

      return
      end
