*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The diff routine calculates d^2/dr^2 + 2z/r - l(l+1)/r^2|p(i)>
*
*****
      subroutine diff(i)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

      mm = maxv(i) - 3
      fl = l(i)
c      tz = z + z
      tz= two*zvar(i)

      c = (fl + d5)**2
      hh = 180.d0*h*h
      do k = 4,mm
         yk(k) = (d2*(p(i,k+3)+p(i,k-3)) - 27.d0*(p(i,k+2)+p(i,k-2)) +
     1        270.d0*(p(i,k+1)+p(i,k-1)) - 490.d0*p(i,k))/hh +
     2        p(i,k)*(tz*r(k) - c )
      enddo

c  *****  Because of the possibility of extensive cancellation near the
c  *****  origin, search for the point where the asymptotic behaviour
c  *****  begins and smooth the origin.

      dlexp=dlr(i)+d2
      y1 = yk(4)/r2(4)/r(4)**dlexp
      y2 = yk(5)/r2(5)/r(5)**dlexp
      do k = 4,100
         kp = k + 2
         y3 = yk(kp)/r2(kp)/r(kp)**dlexp
         if (y2 .eq. d0) go to 1
         if (abs(y1/y2 - d1) .lt. .05d0 .and. 
     1        abs(y3/y2 - d1) .lt. .05d0) go to 2
         y1 = y2
         y2 = y3
 1       continue
      enddo

      write(ouc,3) i
3     format(6x, 'asymptotic region not found for function number',i3)
      stop

c  *****  asymptotic region has been found

2     kp = k
      km = kp - 1
      do k = 1,km
         yk(k) = y1*r2(k)*r(k)**dlexp
      enddo
      mm = mm + 1
      yk(mm) = (-(p(i,mm+2)+p(i,mm-2)) + d16*(p(i,mm+1)+p(i,mm-1))
     1	    -d30*p(i,mm))/(d12*h*h) + p(i,mm)*(tz*r(mm) - c)
      mm = mm + 1
      yk(mm) = (p(i,mm+1) + p(i,mm-1) - d2*p(i,mm))/(h*h) +
     1	 p(i,mm)*(tz*r(mm) - c)
      mm = mm + 1
      do k = mm,no
         yk(k) = d0
      enddo

      return
      end
