*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     de solves the differential equation for the function P/r2 of the
*     orbital i-th
*
*****
      subroutine de(i1)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)
      character*2 aster(3)

      include 'common.inc'
      include 'common-coeff.inc'
c      include 'common-ode.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

      data aster/'  ','* ','**'/

      i=i1
      ed2=e(i,i)
      kk=mmax(ione,meth(i))
      if (nwf .eq. 1) kk=2
      node=n(i)-l(i)-1

c   *****   call method to solve the differential equation

 51   call method(i)
      if ( fail ) go to 25

 12   pn=sqrt(quad(i,m,pde,pde))
      do j=1,m
         pde(j)=pde(j)/pn
      enddo
      azz=azz/pn

c   *****   set the accelerating parameter

      if (ipr .ne. i ) go to 33
      ed2=ed2-e(i,i)
      if (ed1*ed2 .gt. d0) acc(i)=.75d0*acc(i)
      if (ed1*ed2 .lt. d0) acc(i)=(d1+d3*acc(i))/d4
 33   c=acc(i)
      cd=d1-c

c   *****   improve the estimates

      maxv(i)=m
      dp=d0
      do j=1,m
         diff=p(i,j)-pde(j)
         dp=emax(dp   ,abs(diff)*r2(j))
         p(i,j)=pde(j)+c*diff
      enddo
      if (m .eq. no) go to 26
      m=m+1
      do j=m,no
         p(i,j)=d0
      enddo
      az(i)=cd*azz+c*az(i)
      if (c .eq. d0) go to 28
 26   pnn=sqrt(quadr(i,i,izero))

      do j=1,m
         p(i,j)=p(i,j)/pnn
      enddo
      az(i)=az(i)/pnn


 28   if(irel.eq.0) then

c   *****   check the orthogonalization

         do j=1,nwf
            if (j .ge. ib .and. omit ) go to 60
            if (n(i) .eq. n(j) .or. l(i) .ne. l(j)) go to 60
            if (a(i,j,1) .eq. d0 .and. .not. ortho) go to 60
            j1=j
            j2=i
            if ( j .lt. ib .or. dpm(j) .lt. dpm(i)) go to 61
            j1=i
            j2=j
 61         c=quadr(j1,j2,izero)
            d=sqrt(d1-c*c)
            write(ouc,63) el(j1),el(j2),c
 63         format(6x,'<',a3,'|',a3,'>=',1pd8.1)
            if (p(j2,1)-c*p(j1,1) .lt. d0) d=-d
            do jj=1,no
               p(j2,jj)=(p(j2,jj)-c*p(j1,jj))/d
            enddo
            azz=(az(j2)-c*az(j1))/d
            if (azz .gt. d0) az(j2)=emax(azz,d5*az(j2))
            if (j2 .eq. i) go to 60
            call ykf(j2,j2,0)
            do jj=1,no
               y(j2,jj)=yk(jj)
            enddo
 60         continue
         enddo
      endif

c  *****   generate the improved y0 array

      call ykf(i,i,izero)
      do j=1,no
         y(i,j)=yk(j)
      enddo

c     print orbital energies not scaled by 2
      
      write (ouc,17) el(i),e(i,i)/d2,az(i),pn,aster(kk),dp,nj
 17   format(20x,a3,f17.12,f13.7,f17.12, a2,1pd10.2,i7)

 32   dpm(i)=dp
      if (ipr .eq. i1) ed1=ed2
      if (ipr .ne. i1) ed1=ed2-e(i1,i1)
      ipr=i1
      return

c   *****   if method failed to find an acceptable solution,
c   *****   orthogonalize the estimates and try again

 25   continue
      if (irel.eq.0) call orthog
      call grange
 27   call method(i)
      if ( fail ) go to 23
      go to 12

c    *****   error return from second try. if m1 was used,switch to
c	     m2 and try once more.

 23   if ( kk .eq. 2) return
      kk=2
      go to 27
      end
