*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*	The dataqrpot subroutine reads qpot data card
*
*****
      subroutine dataqrpot()   
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

      do i=1,nwf
         qm2(i)=0.d0
         qm1(i)=0.d0
         q0 (i)=0.d0
      enddo
     
c     presence of qrpot label switches on relativistic mode
c     see setparams for default values of reldamp and reldampsf

      irel=1
c     cveldamp - velocity of light times reldamp
      cveldamp=reldamp*cvel

      fsc=d1/cveldamp
      fsc2=fsc*fsc

      iqpot=2
      istate=0

      call inpi(itmp)
      if (itmp.ne.inpiexit) then 
         iqpot=itmp
         if (iqpot.eq.0) then
            irel=0
            return
         endif
         call inpi(itmp)
         if (itmp.ne.inpiexit) then 
            istate=itmp
         endif
      endif

      call relmesg

      return
      end
