*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The data routine reads 'atom', 'electron' and 'integrals' inputa
*     data cards
*
*****
      subroutine data(new)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)
      character*4 bl,el1,el2
      character*1 fint,gint,cfgl24
      character*8 clabel,cfgl8a,cfgl8b,cfgl8c

      include 'common.inc'
      include 'common-input.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-state.inc'
      include 'common-wave.inc'
      data bl/'    '/
      data fint/'F'/,gint/'G'/

c     ncfg - number of configurations is set to 1
      ncfg=1
      new=0

      nf=0
      ng=0
      nr=0
      nl=0

c     *****  read 'atom' card
      call inpa(atom)
      call inpa(term)
      call inpf(z)
      call inpi(nwf)

c     calculate rmax
      rhomax=rho+(no-1)*h
      rmax=exp(rhomax)/z

c     by default all orbitals are being relaxed
      nit=nwf

      call inpi(itmp)
      if (itmp.ne.inpiexit) then 
         nit=itmp
         call inpi(itmp)
         if (itmp.ne.inpiexit) then 
            ncfg=itmp
            call inpi(itmp)
            if (itmp.ne.inpiexit) then 
               nf=itmp
               call inpi(itmp)
               if (itmp.ne.inpiexit) then 
                  ng=itmp
                  call inpi(itmp)
                  if (itmp.ne.inpiexit) then 
                     nr=itmp
                     call inpi(itmp)
                     if (itmp.ne.inpiexit) then 
                        nl=itmp
                     endif
                  endif
               endif
            endif
         endif
      endif

 1    format(2a6,f6.0,i6,7i3,2l3,i3)
      ib = nwf - nit + 1
      nd = no - 2

      write (ouc,2) atom,term,z
2     format(/9x,33hHartree-Fock wave functions for  ,2a6,4h Z =,
     1   f5.1//20x,13hconfiguration,24x,6hweight/)

c      omit = .not. omit
      if (ncfg.eq.1) then
         w = d0
         do i = 1,ncfg
            config(1,i)=''
            config(2,i)=''
            config(3,i)=''
            wt(i) = 1.d0
            w = w + wt(i)**2
         enddo
      else

         write(ouc,100)
 100     format(
     & 'Warning!',/,'Multiconfiguration calculations are not supported',
     & ' by the present version of the program.'
     & /,'Modify subroutine data.f to proceed.')
c         stop 'data'

         w = d0
         do i = 1,ncfg
c            read (iuc,*) config(1,i),config(2,i),config(3,i),wtt,lwt
            call cardc(1)
            call inpa(clabel)
            config(1,i)=clabel
            config(2,i)=''
            config(3,i)=''
            call inpf(ftmp)
            if (ftmp.ne.0.d0) then
               wt(i)=ftmp
            else
               wt(i)=one
            endif
            w = w + wt(i)**2
         enddo
      endif

c     normalize configuration weights
      w = sqrt(w)
      do i = 1,ncfg
         wt(i) = wt(i)/w
         write (ouc,5) i, config(1,i), config(2,i), config(3,i),wt(i)
      enddo
5     format(14x,i2,6x,3a8,f19.8)

      write(ouc,6) (i,i=1,ncfg)
6     format(/9x,10hinput data/9x,10h----- ----//13x,14hwave function,,
     1   11h  procedure,2x,41hnumber of electrons in each configuration/
     2   17x,26hn  l  sigma meth  acc  ind,20i4/40x,20i4)

      write(ouc,*)

c     *****  read 'electron' card
      call datael

      write(ouc,66)
66    format(/)

      write (ouc,10)
10    format(/9x,9henergy = ,9x,12he(average) + /)

c     *****  read 'fk' and 'gk' cards

      nfg = nf + ng
      if (nfg .eq. 0) go to 13
      do i = 1,nfg
         read (iud,*) cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
 11      format(g12.8,a1,i1,1x,2i2,1x,2i2)

c         if ( oud .eq. 0 ) go to 20
         i1 = ifg(i)
         i2 = jfg(i)
         write (ouc,12) cfg(i),nci(i),ncj(i),fint,kfg(i),el(i1),el(i2)
 12      format(26x,f14.8,3h*c(,i2,4h)*c(,i2,2h),,a1,i1,
     1        1h(,a3,1h,,a3,1h))
 20      continue
      enddo

13    if (nr .eq. 0) go to 17

c     *****  read 'rk' cards and set rscan(i)=.false. if wavefunction  i
c     *****  is present in the rk integral

      do i=1,nr
         read (iud,*) cr(i),kr(i),i1r(i),i2r(i),ncri(i),j1r(i),j2r(i),
     1        ncrj(i),io(i),jo(i),iq(i)
 15      format(g12.8,1x,i1,1x,3i2,1x,3i2,2x,i2,1x,i2,1x,i2)
         i1 = i1r(i)
         i2 = i2r(i)
         j1 = j1r(i)
         j2 = j2r(i)
         if (iq(i) .eq. 0) go to 30
         ii = io(i)
         jj = jo(i)
         rscan(ii) = .false.
         rscan(jj) = .false.
 30      continue

         write (ouc,16) cr(i),ncri(i),ncrj(i),kr(i),el(i1),el(i2),
     1        el(j1),el(j2),bl,bl,iq(i)
 16      format(26x,f14.8,3h*c(,i2,4h)*c(,i2,3h) R,i1,
     1        1h(,2a3,1h,,2a3,2h)<,a3,1h|,a3,1h>,i2)
         if ( abs(cr(i)) .lt. 1.d-20 ) go to 14
 23      rscan(i1) = .false.
         rscan(i2) = .false.
         rscan(j1) = .false.
         rscan(j2) = .false.
 14      continue
      enddo

17    if (nl .eq. 0) go to 31

c  *****  read 'l' cards

      do i = 1,nl
         read (iud,*) cl(i),ili(i),ncli(i),ilj(i),nclj(i),ilo(i),jlo(i),
     1        lq(i)
 33      format(f12.8,2x,2i2,1x,2i2,2x,i2,1x,i2,1x,i2)
         i1 = ili(i)
         j1 = ilj(i)
         if (lq(i) .eq. 0) go to 34
         i2 = ilo(i)
         j2 = jlo(i)
         el1 = el(i2)
         el2 = el(j2)
         rscan(i2) = .false.
         rscan(j2) = .false.

         write (ouc,35) cl(i),ncli(i),nclj(i),el(i1),
     1        el(j1),el1,el2,lq(i)
         go to 24

 34      continue

         write (ouc,35) cl(i),ncli(i),nclj(i),el(i1),el(j1),bl,bl,lq(i)
 35      format(26x,f14.8,3h*c(,i2,4h)*c(,i2,4h) l(,a3,1h,,a3,2h)<,
     1        a3,1h|,a3,1h>,i2)

 24      rscan(i1) = .false.
         rscan(j2) = .false.
 32      continue
      enddo

31    continue
c FIXME
c      write(ouc,25) nf, ng, nr, nl
c25    format(19x,i3,17h fk integral(s) +/19x,i3,17h gk integral(s) +/
c     1	     19x,i3,17h rk integral(s) +/19x,i3,15h  l integral(s) )

      return

19    stop
      end










