********************************************************************************
*                                                                              *
*  2DHF version 2-2005                                                         *
*  Copyright (C) 1996  Jacek Kobus, Leif Laaksonen, Dage Sundholm              *
*                                                                              *
*  This software may be used and distributed according to the terms            *
*  of the GNU General Public License, see README and COPYING.                  *
*                                                                              *
********************************************************************************
c ### card ### 
c
c     This routine reads a data card and scans it for nonspace fields.
c     The number of fields is stored in jump, the starting point of a
c     field in istrt(i) and the number of characters in that field
c     in inumb(i).
c     If the routine finds an exclamation mark anything following it
c     is considered as a comment.
c
      subroutine card
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      parameter (i40=40, i80=80)
      character*1 ia,iexm,iblnk,hash
      character*1 iatmp(80)
      common/iochan/ iinp5,iinp11,iinp12,iinp13,iinp14,
     &               iout6,iout21,iout22,iout23,iout24
      common/work/jrec,jump,istrt(i40),inumb(i40),ia(i80)
      data iblnk/' '/,iexm/'!'/,hash/'#'/

      iinp5=5
      iout6=6

      do i=1,i80
         ia(i)=' '
      enddo

c     read a line 

      jump = 0
      jrec = 0
      isw = 0  
 1    read(iinp5,100,err=110,end=40) ia
 100  format(80a1)
 101  format(2x,80a1)
 110  continue

      do i=1,i80
         iatmp(i)=ia(i)
      enddo

c     set into lower case 
c     FC3, ifort: error while passing i80 to a subroutine                                                                     
      it=i80
      call lowcase(iatmp,it)

c     check for tabs, and replace it by a blank

      call tabchk(iatmp,it)

c     check for blanks at left and remove them, fill with blanks at the end  

      call lftpos(iatmp,it) 

      do i=1,i80
         ia(i)=iatmp(i)
      enddo

c     echo the slightly modified input data

c      write(iout6,101) ia 

c     check for the exclamation mark
      
      do ike=1,i80
         ile=ike
         if (ia(ile).eq.iexm.or.ia(ile).eq.hash) go to 910
      enddo 

 910  if(ile.eq.1) go to 1
      if(ia(ile).eq.iexm.or.ia(ile).eq.hash) ile=ile-1

      do i = 1,ile
         if (ia(i).eq.iblnk) goto 25
         if (isw) 15,15,20
 15      jump = jump +1
         istrt(jump) = i
         inumb(jump) = 0
         isw=1
 20      inumb(jump) = inumb(jump) + 1
         go to 30
 25      isw = 0
 30      continue
      enddo
      if (jump.eq.0) goto 1
      return

 40   write(iout6,45)
 45   format(//1x,'******* end of input file *******'//)
      stop 'card'
      end


c     This is a version of the card routine that allows to read data
c     with the case of symbols preserved

      subroutine cardc(ichgecase)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      parameter (i40=40, i80=80)
      character*1 ia,iexm,iblnk,hash
      character*1 iatmp(80)
      common/iochan/ iinp5,iinp11,iinp12,iinp13,iinp14,
     &               iout6,iout21,iout22,iout23,iout24
      common/work/jrec,jump,istrt(i40),inumb(i40),ia(i80)
      iinp5=5
      iout6=6
      data iblnk/' '/,iexm/'!'/,hash/'#'/

c     ichgecase  = 0: lower case before extracting data
c     ichgecase <> 0: leave case unchanged

      do i=1,i80
         ia(i)=' '
      enddo

c     read a line 

      jump = 0
      jrec = 0
      isw = 0
 1    read(iinp5,100,err=110,end=40) ia
 100  format(80a1)
 101  format(2x,80a1)
 110  continue

      do i=1,i80
         iatmp(i)=ia(i)
      enddo

c     set into lower case 
c     FC3, ifort: error while passing i80 to a subroutine                                                                     
      it=i80
      if (ichgecase.eq.0) call lowcase(iatmp,it)

c     check for tabs, and replace them by blanks

      call tabchk(iatmp,it)

c     check for blanks at left and remove them, fill with blanks at the end  

      call lftpos(iatmp,it) 

      do i=1,i80
         ia(i)=iatmp(i)
      enddo

c     echo the slightly modified input data

c      write(iout6,101) ia 

c     check for the exclamation mark
      
      do ike=1,i80
         ile=ike
         if (ia(ile).eq.iexm.or.ia(ile).eq.hash) go to 910
      enddo 

 910  if(ile.eq.1) go to 1
      if(ia(ile).eq.iexm.or.ia(ile).eq.hash) ile=ile-1

      do i = 1,ile
         if (ia(i).eq.iblnk) goto 25
         if (isw) 15,15,20
 15      jump = jump +1
         istrt(jump) = i
         inumb(jump) = 0
         isw=1
 20      inumb(jump) = inumb(jump) + 1
         go to 30
 25      isw = 0
 30      continue
      enddo
      if (jump.eq.0) goto 1
      return

 40   write(iout6,45)
 45   format(//1x,'******* end of input file *******'//)
      stop 'card'
      end


c ### lftpos ###
c
c Eliminates blanks to the left and left position chararcter string card.
c 
      subroutine lftpos(line,length)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      character*1 line(length)

      ieff = 0
      do ipos = 1, length
         if(ieff.gt.0) then
            ieff=ieff+1
            line(ieff) = line(ipos)
         end if
         if(line(ipos).ne.' '.and.ieff.eq.0) then
            ieff=1
            line(ieff) = line(ipos)
         end if 
      end do  

c     fill end with trailing blanks

      do ipos = ieff+1,length 
         line(ipos) = ' '
      end do 

      ntest = 0
      if(ntest.ne.0) then
         write(6,*) ' Left adjusted character string '
         write(6,'(1H ,A)') line
      end if

      return
      end

c ### lowcas ### 
c
c Converts letters in a character string line to the lower case.
c
      subroutine lowcase(line,length)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      character*1 line(length)
      character*1 lower(26)
      character*1 upper(26)

      data lower/'a','b','c','d','e',
     &           'f','g','h','i','j',
     &           'k','l','m','n','o',
     &           'p','q','r','s','t',
     &           'u','v','w','x','y',
     &           'z'/
      data upper/'A','B','C','D','E',
     &           'F','G','H','I','J',
     &           'K','L','M','N','O',
     &           'P','Q','R','S','T',
     &           'U','V','W','X','Y',
     &           'Z'/

      do icha = 1, length
         do i = 1,26
            if(line(icha).eq.upper(i))
     &           line(icha) = lower(i)
         end do  
      end do  
      return 
      end 

c ### tabchk ###
c
c     Searches for a tab in the string line and replace it by a space.
c
      subroutine tabchk(line,length)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      character*1 itab
      character*1 line(length)

      itab=char(9)
      do i=1,length
         if(line(i).eq.itab) then
            line(i)=' '
         end if
      end do
      return
      end

********************************************************************************
*                                                                              *
*  2DHF version 2-2005                                                         *
*  Copyright (C) 1996  Jacek Kobus, Leif Laaksonen, Dage Sundholm              *
*                                                                              *
*  This software may be used and distributed according to the terms            *
*  of the GNU General Public License, see README and COPYING.                  *
*                                                                              *
********************************************************************************
c ### inpa ###
c
c    This routine examines the contents of IA and extracts a
c    character string of 8 chars. This string is stored in IBUF.
c    The remaining non-blank characters (if any) are ignored.

      subroutine inpa(guf)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      parameter (i40=40, i80=80)
      character*1 ia,iblnk,iall,ibuf
      character*8 ibufr,guf

      common/iochan/ iinp5,iinp11,iinp12,iinp13,iinp14,
     &               iout6,iout21,iout22,iout23,iout24
      common/work/jrec,jump,istrt(i40),inumb(i40),ia(i80)
      dimension ibuf(8),iall(60)
      equivalence (ibuf(1),ibufr)

      data iblnk/' '/
      data iall/'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j',
     &          'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't',
     &          'u', 'v', 'w', 'x', 'y', 'z', '-', '-', '-', ' ',
     &          'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
     &          'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
     &          'U', 'V', 'W', 'X', 'Y', 'Z', '-', '-', '-', ' '/

      do i=1,8
         ibuf(i)=iblnk
      enddo
      jrec = jrec + 1
      if(jrec .gt. jump) goto 11
      n = inumb(jrec)
      nstrt = istrt(jrec)
      if (n.gt.8) n=8
      do i = 1,n
         ibuf(i) = ia(nstrt)
         nstrt = nstrt + 1
      enddo

11    guf=ibufr

      return
      end
********************************************************************************
*                                                                              *
*  2DHF version 2-2005                                                         *
*  Copyright (C) 1996  Jacek Kobus, Leif Laaksonen, Dage Sundholm              *
*                                                                              *
*  This software may be used and distributed according to the terms            *
*  of the GNU General Public License, see README and COPYING.                  *
*                                                                              *
********************************************************************************
c ### inpi ###
c
c    This routine reads an integer from the array IA,
c    starting at IA(istrt(jrec)) and continuing for inumb(jrec))
c    elements. Plus signs are ignored, the answer is accumulated
c    in JBUF.
c
      subroutine inpi(jbuf)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      parameter (i40=40, i80=80)
      character*1 ia,ichar(14),itemp
      common/iochan/ iinp5,iinp11,iinp12,iinp13,iinp14,
     &               iout6,iout21,iout22,iout23,iout24
      common/work/jrec,jump,istrt(i40),inumb(i40),ia(i80)
      data ichar/'0','1','2','3','4','5','6','7','8','9',
     &           '+','&','^','-'/,inpiexit/-99999/

      jbuf = inpiexit
      jrec = jrec + 1
      if(jrec.gt.jump)goto 430
      jbuf=0
      n = inumb(jrec)
      ifact = 1
      ist=istrt(jrec)
      nstrt = ist + n - 1
      do i = 1,n
         itemp = ia(nstrt)
         do j=1,14
            if(ichar(j).eq.itemp) goto 45
         enddo
 44      write(iout6,*) 'Error detected in inpi'
         stop 'inpi'

 45      if(j.lt.11)goto 47
         if(nstrt.ne.ist)goto 44
         if(j.ge.14)jbuf=-jbuf
         goto 430
 47      jbuf=jbuf+(j-1)*ifact
         ifact = ifact * 10
         nstrt=nstrt-1
      enddo

430   return
      end

********************************************************************************
*                                                                              *
*  2DHF version 2-2005                                                         *
*  Copyright (C) 1996  Jacek Kobus, Leif Laaksonen, Dage Sundholm              *
*                                                                              *
*  This software may be used and distributed according to the terms            *
*  of the GNU General Public License, see README and COPYING.                  *
*                                                                              *
********************************************************************************
c ### inpf ###
c
c     Extracts a floating point number from an input card.
c
      subroutine inpf(buf)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      parameter (i40=40, i80=80)
      character*1 ia,ichar(16),itemp
      common/iochan/ iinp5,iinp11,iinp12,iinp13,iinp14,
     &               iout6,iout21,iout22,iout23,iout24
      common/work/jrec,jump,istrt(i40),inumb(i40),ia(i80)
      data ichar/'0','1','2','3','4','5','6','7','8','9','+','&','^',
     &'-','.','e'/

      limit=16
      jrec = jrec + 1
      buf=0.d0
      if(jrec .gt. jump) return
      buf = 0.d0      
      fact2 = 0.d0
      iexp=0
      n = inumb(jrec)
      fact = 1.d0
      ist=istrt(jrec)
      nstrt = ist + n - 1
      iexpdig=0
      do i=1,n
         itemp = ia(nstrt)
         do j = 1,limit
            if(ichar(j).eq.itemp) goto 5
         enddo

 4       write(iout6,*) 'Error detected in inpf'
         stop 'inpf' 

 5       continue
         if (j.eq.16) goto 12
         if (j.lt.11) goto 7
         if (j.le.14) goto 6
         if (iexp.eq.1) then
            fact2 = dble(i-1-iexpdig)
         else
            fact2 = dble(i-1)
         endif
         go to 9

 12      continue
         if (iexp.eq.0) then
            buf=(0.1d0**fact2)*buf
            exponent=buf
            iexp=1
            buf=0
            fact=1.0
            fact2=0.0
            iexpdig=i
         endif
         goto 9

 15      continue
         buf = buf + dble(j-1) * fact
         fact=fact*10.d0
         goto 9

 6       continue
c         if(nstrt.ne.ist.and.iexp.eq.0) go to 4
         if(j.eq.14) buf=-buf
         goto 9

 7       buf = buf + dble(j-1) * fact
         fact=fact*10.d0
 9       continue
         nstrt = nstrt - 1
      enddo

      if (iexp.eq.1) then
         buf=(0.1d0**fact2)*buf
         buf=buf*10.d0**exponent
         return
      endif
 20   buf=(0.1d0**fact2)*buf
      return

      end

C$$$      subroutine inpf(buf)
C$$$      implicit integer*4 (i-n)
C$$$      implicit real*8 (a-h,o-z)
C$$$      parameter (i40=40, i80=80)
C$$$      character*1 ia,ichar(15),itemp
C$$$      common/iochan/ iinp5,iinp11,iinp12,iinp13,iinp14,
C$$$     &               iout6,iout21,iout22,iout23,iout24
C$$$      common/work/jrec,jump,istrt(i40),inumb(i40),ia(i80)
C$$$      data ichar/'0','1','2','3','4','5','6','7','8','9','+','&','^',
C$$$     &'-','.'/

C$$$      limit=16
C$$$      jrec = jrec + 1
C$$$      if(jrec .gt. jump) go to 40
C$$$      buf = 0.d0
C$$$      fact2 = 0.d0
C$$$      limit=15
C$$$      n = inumb(jrec)
C$$$      fact = 1.d0
C$$$      ist=istrt(jrec)
C$$$      nstrt = ist + n - 1
C$$$      do i=1,n
C$$$         itemp = ia(nstrt)
C$$$         do j = 1,limit
C$$$            if(ichar(j).eq.itemp)goto 5
C$$$         enddo

C$$$ 4       write(iout6,*) 'Error detected in inpf'
C$$$         stop 'inpf' 

C$$$ 5       if(j.lt.11) goto 7
C$$$         if(j.le.14) goto 6
C$$$         fact2 = dble(i-1)
C$$$         limit=14
C$$$         go to 9

C$$$ 6       if(nstrt .ne. ist) go to 4
C$$$         if(j.eq.14)buf=-buf
C$$$         go to 20

C$$$ 7       buf = buf + dble(j-1) * fact
C$$$         fact=fact*10.d0
C$$$ 9       continue
C$$$         nstrt = nstrt - 1
C$$$      enddo

C$$$ 20   buf=(0.1d0**fact2)*buf
C$$$ 40   return
C$$$      end

********************************************************************************
*                                                                              *
*  2DHF version 2-2005                                                         *
*  Copyright (C) 1996  Jacek Kobus, Leif Laaksonen, Dage Sundholm              *
*                                                                              *
*  This software may be used and distributed according to the terms            *
*  of the GNU General Public License, see README and COPYING.                  *
*                                                                              *
********************************************************************************
c ### prtlabel ### 
c
c     This routine prints a label read by card

      subroutine prtlabel
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      parameter (i40=40, i80=80)
      character*1 ia
      common/work/jrec,jump,istrt(i40),inumb(i40),ia(i80)
 
      write(*,'(1x,80a1)') (ia(i),i=1,80)
      return
      end


