*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The array subroutine generates the arrays of coefficients
*     function
*
*****
      subroutine array
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-coeff.inc'
      include 'common-param.inc'
      include 'common-state.inc'
      include 'common-wave.inc'

c  *****  initialize arrays

      do i=1,nwf
         sum(i) = d0
         do j=1,nwf
            do k=1,5
               a(i,j,k) = d0
               b(i,j,k) = d0
            enddo
         enddo
      enddo

c  *****  determine coefficients for average energies of configurations

      do k=1,ncfg
         c = wt(k)**2
         do i=1,nwf
            if (qc(i,k) .eq. d0) go to 3
            li = l(i)+1
            if (li .gt. 5) go to 3
            do j=1,nwf
               if (qc(j,k) .eq. d0) go to 4
               lj = l(j)+1
               if (lj .gt. 5) go to 4
               if (i .ne. j) go to 5
               cc = c*qc(i,k)*(qc(i,k) - d1)
               a(i,i,1) = a(i,i,1) + cc
               if (li .eq. 1) go to 4
               do kl = 2,li
                  a(i,i,kl) = a(i,i,kl) - cc*ca(li-1,kl-1)
               enddo
               go to 4
 5             cc = c*qc(i,k)*qc(j,k)
               a(i,j,1) = a(i,j,1) + cc
               do kl=1,5
                  b(i,j,kl) = b(i,j,kl) - cc*cb(li,lj,kl)
               enddo
 4             continue
            enddo
 3          continue
            sum(i) = sum(i) + c*qc(i,k)
         enddo
 2       continue
      enddo

c  *****  correct coefficients for deviations from the average for a
c  *****  specific sl term as determined by the input data
c
      if (nf .eq. 0) go to 10
c
c  *****  corrections due to 'fk' integrals
c
      do i=1,nf
         k = kfg(i)/2 + 1
         ni = nci(i)
         nj = ncj(i)
         con = cfg(i)*wt(ni)*wt(nj)
         ii = ifg(i)
         ij = jfg(i)
         a(ii,ij,k) = a(ii,ij,k) + con
         a(ij,ii,k) = a(ij,ii,k) + con
      enddo

10    if (ng .eq. 0) go to 12

c  *****  corrections due to 'gk' integrals

      nfg=nf+ng
      nfp = nf + 1
      do i=nfp,nfg
         ii = ifg(i)
         ij = jfg(i)
         ni = nci(i)
         nj = ncj(i)
         li = l(ii)
         lj = l(ij)
         kl = (kfg(i) - abs(li - lj))/2 + 1
         con = cfg(i)*wt(ni)*wt(nj)
         b(ii,ij,kl) = b(ii,ij,kl) + con
         b(ij,ii,kl) = b(ij,ii,kl) + con
      enddo

c  *****  divide all arrays for function i by the expected occupation
c  *****  number for function i, if different from zero

12    do i = 1,nwf
         if (sum(i) .eq. d0) go to 15
         do j=1,nwf
            do k=1,5
               a(i,j,k) = a(i,j,k)/sum(i)
               b(i,j,k) = b(i,j,k)/sum(i)
            enddo
         enddo
 15      continue
      enddo

      return
      end


*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The array subroutine generates the arrays of coefficients
*     function
*
*****
      subroutine arraydft
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-coeff.inc'
      include 'common-param.inc'
      include 'common-state.inc'
      include 'common-wave.inc'

c  *****  initialize arrays

      do i=1,nwf
         sum(i) = d0
         do j=1,nwf
            do k=1,5
               a(i,j,k) = d0
               b(i,j,k) = d0
            enddo
         enddo
      enddo

c  *****  determine coefficients for average energies of configurations

      do k=1,ncfg
         c = wt(k)**2
         do i=1,nwf
            if (qc(i,k) .eq. d0) go to 3
            li = l(i)+1
            if (li .gt. 5) go to 3
            do j=1,nwf
               if (qc(j,k) .eq. d0) go to 4
               lj = l(j)+1
               if (lj .gt. 5) go to 4
               if (i .ne. j) go to 5
c               cc = c*qc(i,k)*(qc(i,k) - d1)
               cc = c*qc(i,k)*(qc(i,k))
               a(i,i,1) = a(i,i,1) + cc
               if (li .eq. 1) go to 4
               do kl = 2,li
                  a(i,i,kl) = a(i,i,kl) - cc*ca(li-1,kl-1)
               enddo
               go to 4
 5             cc = c*qc(i,k)*qc(j,k)
               a(i,j,1) = a(i,j,1) + cc
               do kl=1,5
                  b(i,j,kl) = b(i,j,kl) - cc*cb(li,lj,kl)
               enddo
 4             continue
            enddo
 3          continue
            sum(i) = sum(i) + c*qc(i,k)
         enddo
 2       continue
      enddo

c  *****  correct coefficients for deviations from the average for a
c  *****  specific sl term as determined by the input data
c
      if (nf .eq. 0) go to 10
c
c  *****  corrections due to 'fk' integrals
c
      do i=1,nf
         k = kfg(i)/2 + 1
         ni = nci(i)
         nj = ncj(i)
         con = cfg(i)*wt(ni)*wt(nj)
         ii = ifg(i)
         ij = jfg(i)
         a(ii,ij,k) = a(ii,ij,k) + con
         a(ij,ii,k) = a(ij,ii,k) + con
      enddo

10    if (ng .eq. 0) go to 12

c  *****  corrections due to 'gk' integrals

      nfg=nf+ng
      nfp = nf + 1
      do i=nfp,nfg
         ii = ifg(i)
         ij = jfg(i)
         ni = nci(i)
         nj = ncj(i)
         li = l(ii)
         lj = l(ij)
         kl = (kfg(i) - abs(li - lj))/2 + 1
         con = cfg(i)*wt(ni)*wt(nj)
         b(ii,ij,kl) = b(ii,ij,kl) + con
         b(ij,ii,kl) = b(ij,ii,kl) + con
      enddo

c  *****  divide all arrays for function i by the expected occupation
c  *****  number for function i, if different from zero

12    do i = 1,nwf
         if (sum(i) .eq. d0) go to 15
         do j=1,nwf
            do k=1,5
               a(i,j,k) = a(i,j,k)/sum(i)
               b(i,j,k) = b(i,j,k)/sum(i)
            enddo
         enddo
 15      continue
      enddo

      return
      end
