﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Xml.Linq;

namespace KolekcjeWPF.Model
{
    public static class PlikXml
    {
        private static IFormatProvider formatProvider = CultureInfo.InvariantCulture;

        public static void Zapisz(this Zadania zadania, string ścieżkaPliku)
        {            
            XDocument xml = new XDocument(
                new XElement("Zadania",
                    from Zadanie zadanie in zadania
                    select new XElement("Zadanie",
                        new XElement("Opis", zadanie.Opis),
                        new XElement("TerminRealizacji",
                            zadanie.PlanowanaDataRealizacji.ToString(formatProvider)),
                        new XElement("DataUtworzenia",
                            zadanie.DataUtworzenia.ToString(formatProvider)),
                        new XElement("Priorytet", ((byte)zadanie.Priorytet).ToString(formatProvider)),
                        new XElement("CzyZrealizowane", zadanie.CzyZrealizowane.ToString(formatProvider)))));
            xml.Save(ścieżkaPliku);
        }

        public static Zadania Czytaj(string ścieżkaPliku)
        {
            XDocument xml = XDocument.Load(ścieżkaPliku);
            IEnumerable<Zadanie> zadania = from XElement zadanie in xml.Root.Descendants("Zadanie")
                                           select new Zadanie(
                                               zadanie.Element("Opis").Value,
                                               DateTime.Parse(zadanie.Element("TerminRealizacji").Value),
                                               DateTime.Parse(zadanie.Element("DataUtworzenia").Value),
                                               (PriorytetZadania)byte.Parse(zadanie.Element("Priorytet").Value),
                                               bool.Parse(zadanie.Element("CzyZrealizowane").Value));
            Zadania _zadania = new Zadania();
            foreach (Zadanie zadanie in zadania) _zadania.Dodaj(zadanie);
            return _zadania;
        }
    }
}
