﻿using System;
using System.Windows.Input;

namespace RównaniaKwadratowe2.ModelWidoku
{
    public class RozwiążCommand : ICommand
    {
        public event EventHandler CanExecuteChanged
        {
            add
            {
                CommandManager.RequerySuggested += value;
            }
            remove
            {
                CommandManager.RequerySuggested -= value;
            }
        }

        private RozwiązywaczRównańKwadratowych model;

        public RozwiążCommand(RozwiązywaczRównańKwadratowych model)
        {
            this.model = model;
        }

        public WspółczynnikiRównaniaKwadratowego Współczynniki = new WspółczynnikiRównaniaKwadratowego();

        public bool CanExecute(object parameter)
        {
            /*
            if (parameter == null) return false;
            if (parameter is WspółczynnikiRównaniaKwadratowego)
            {
                WspółczynnikiRównaniaKwadratowego współczynniki = (WspółczynnikiRównaniaKwadratowego)parameter;
                return współczynniki.CzyIstniejąRozwiązania;
            }
            else return false;
            */
            return Współczynniki.CzyIstniejąRozwiązania;
        }

        public void Execute(object parameter)
        {
            /*
            WspółczynnikiRównaniaKwadratowego współczynniki = (WspółczynnikiRównaniaKwadratowego)parameter;
            model.Rozwiąż(współczynniki);
            if (Executed != null) Executed(this, EventArgs.Empty);
            */
            model.Rozwiąż(Współczynniki);
            if (Executed != null) Executed(this, EventArgs.Empty);
        }

        public event EventHandler Executed;
    }
}
