﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SortowanieBabelkowe
{
    class Program
    {
        const int liczbaElementów = 15;
        const int maksymalnaWartość = 100;

        #region Integer
        static void zamienWartosci(ref int i, ref int j)
        {
            int tmp = i;
            i = j;
            j = tmp;
        }                

        static void wyswietlWartosciTablicy(int[] tablica)
        {
            string s = "";
            for (int i = 0; i < tablica.Length; ++i) s += tablica[i].ToString() + "; ";
            Console.WriteLine(s);
        }

        static void Main_Integer()
        {
            Random r = new Random();

            int[] tablica = new int[liczbaElementów];
            for (int i = 0; i < tablica.Length; ++i) tablica[i] = r.Next(maksymalnaWartość);

            bool jeszczeNiePosortowane = true;
            int krokSortowania = 0;
            do
            {
                wyswietlWartosciTablicy(tablica);
                //MessageBox.Show("Krok sortowania "+krokSortowania.ToString());
                jeszczeNiePosortowane = false;
                for (int i = 0; i < tablica.Length - 1 - krokSortowania; ++i)
                {
                    if (tablica[i + 1] < tablica[i])
                    {
                        zamienWartosci(ref tablica[i], ref tablica[i + 1]);
                        jeszczeNiePosortowane = true;
                    }
                }
                krokSortowania++;
            }
            while (jeszczeNiePosortowane);
        }
        #endregion

        #region IComparable i IComparable<T>
        static void zamienWartosci<T>(ref T i, ref T j)
        {
            T tmp = i;
            i = j;
            j = tmp;
        }

        static void wyswietlWartosciTablicy<T>(T[] tablica)
        {
            string s = "";
            for (int i = 0; i < tablica.Length; ++i) s += tablica[i].ToString() + "; ";
            Console.WriteLine(s);
        }

        static void SortowanieBabelkowe(IComparable[] tablica)
        {
            bool jeszczeNiePosortowane = true;
            int krokSortowania = 0;
            do
            {
                wyswietlWartosciTablicy(tablica);
                jeszczeNiePosortowane = false;
                for (int i = 0; i < tablica.Length - 1 - krokSortowania; ++i)
                {
                    if (tablica[i + 1].CompareTo(tablica[i]) < 0)
                    {
                        zamienWartosci(ref tablica[i], ref tablica[i + 1]);
                        jeszczeNiePosortowane = true;
                    }
                }
                krokSortowania++;
            }
            while (jeszczeNiePosortowane);
        }

        static void SortowanieBabelkowe<T>(IComparable<T>[] tablica)
        {
            bool jeszczeNiePosortowane = true;
            int krokSortowania = 0;
            do
            {
                wyswietlWartosciTablicy(tablica);
                jeszczeNiePosortowane = false;
                for (int i = 0; i < tablica.Length - 1 - krokSortowania; ++i)
                {
                    if (tablica[i + 1].CompareTo((T)tablica[i]) < 0)
                    {
                        zamienWartosci(ref tablica[i], ref tablica[i + 1]);
                        jeszczeNiePosortowane = true;
                    }
                }
                krokSortowania++;
            }
            while (jeszczeNiePosortowane);
        }

        static void Main_IComparable()
        {
            Random r = new Random();

            IComparable[] tablica = new IComparable[liczbaElementów];
            for (int i = 0; i < tablica.Length; ++i) tablica[i] = r.Next(maksymalnaWartość);

            SortowanieBabelkowe(tablica);
        }

        static void Main_IComparable_T()
        {
            Random r = new Random();

            IComparable<int>[] tablica = new IComparable<int>[liczbaElementów];
            for (int i = 0; i < tablica.Length; ++i) tablica[i] = r.Next(maksymalnaWartość);

            SortowanieBabelkowe(tablica);
        }
        #endregion

        static void Main(string[] args)
        {
            Console.WriteLine("Integer:");
            Main_Integer();
            Console.WriteLine();

            Console.WriteLine("IComparable:");
            Main_IComparable();
            Console.WriteLine();

            Console.WriteLine("IComparable<T>:");
            Main_IComparable_T();
        }
    }
}
