﻿using System.ComponentModel;

namespace ZegarMAUI.ModelWidoku
{
    internal class Zegar : INotifyPropertyChanged
    {
        private DateTime poprzedniCzas = DateTime.Now;

        public DateTime AktualnyCzas
        {
            get
            {
                return DateTime.Now;
            }
        }

        public event PropertyChangedEventHandler? PropertyChanged;

        private void onPropertyChanged()
        {
            if ((AktualnyCzas - poprzedniCzas) < TimeSpan.FromSeconds(1) &&
                AktualnyCzas.Second == poprzedniCzas.Second)
                return;

            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(AktualnyCzas)));
        }

        private const int okresOdświeżaniaWidokuMs = 250;

        public Zegar()
        {
            IDispatcherTimer timerOdświeżaniaWidoku =
                Application.Current.Dispatcher.CreateTimer();
            timerOdświeżaniaWidoku.Tick +=
                (sender, e) =>
                {
                    onPropertyChanged();
                };
            timerOdświeżaniaWidoku.Interval = TimeSpan.FromMilliseconds(okresOdświeżaniaWidokuMs);
            timerOdświeżaniaWidoku.Start();
        }
    }
}