﻿using CommunityToolkit.Maui.Core.Primitives;
using CommunityToolkit.Maui.Views;

namespace Odtwarzanie
{
    public partial class MainPage : ContentPage
    {
        public MainPage()
        {
            InitializeComponent();

            mediaElement.MediaEnded +=
                (object? sender, EventArgs e) =>
                {
                    button.BackgroundColor = Colors.Green;
                    button.Text = "Od nowa";
                };
        }

        private void button_Clicked(object sender, EventArgs e)
        {
            switch(mediaElement.CurrentState)
            {
                case MediaElementState.Playing:
                    mediaElement.Pause();
                    break;
                case MediaElementState.Paused:
                case MediaElementState.Stopped:
                    mediaElement.Play();
                    break;
            }
        }
    }

}
