﻿namespace ZdjęciaMAUI
{
    public partial class MainPage : ContentPage
    {
        public MainPage()
        {
            InitializeComponent();
        }

        private string ścieżkaDoPliku = "";

        private async void button_Clicked(object sender, EventArgs e)
        {
            if (MediaPicker.Default.IsCaptureSupported)
            {
                FileResult wynik = await MediaPicker.Default.CapturePhotoAsync();
                if (wynik != null)
                {
                    ścieżkaDoPliku = Path.Combine(FileSystem.CacheDirectory, wynik.FileName);
                    label.Text = $"Ścieżka pliku: {ścieżkaDoPliku}";
                    label.TextColor = Colors.Black;

                    using Stream strumień = await wynik.OpenReadAsync();
                    await strumień.CopyToAsync(File.OpenWrite(ścieżkaDoPliku));

                    try
                    {
                        image.Source = ImageSource.FromFile(ścieżkaDoPliku);
                    }
                    catch (Exception exc)
                    {
                        label.Text = "Wyjątek: " + exc.Message;
                        label.TextColor = Colors.DarkRed;
                    }
                }
                else
                {
                    label.Text = "Nie udało się zrobić zdjęcia";
                    label.TextColor = Colors.DarkRed;
                }
            }
        }
    }

}
