﻿using System.Windows.Input;

namespace PierwszaAplikacjaMAUI.ModelWidoku
{
    internal class RelayCommand : ICommand
    {
        public event EventHandler? CanExecuteChanged;

        private Action<object?> execute;
        private Predicate<object?> canExecute;

        public RelayCommand(Action<object?> execute, Predicate<object?> canExecute = null)
        {
            if (execute == null) throw new ArgumentNullException();
            this.execute = execute;
            this.canExecute = canExecute;
        }

        public bool CanExecute(object? parameter)
        {
            if (canExecute == null) return true;
            else return canExecute(parameter);
        }

        public void Execute(object? parameter)
        {
            execute(parameter);
        }
    }
}
