﻿using Microsoft.Maui.Controls.Shapes;
using System.Globalization;

namespace PierwszaAplikacjaMAUI
{
    public class ByteToDoubleConverter : IValueConverter
    {
        public object? Convert(object? value, Type targetType, object? parameter, CultureInfo culture)
        {
            byte b = (byte)value;
            return (double)b/255.0;
        }

        public object? ConvertBack(object? value, Type targetType, object? parameter, CultureInfo culture)
        {
            double d = (double)value;
            return (byte)Math.Round(d * 255);            
        }
    }
}
