﻿using System;

namespace Polecenie
{
    class Konto
    {
        private int numerKonta;
        private decimal saldo;

        public Konto(int numerKonta, decimal saldoPoczatkowe)
        {
            this.numerKonta = numerKonta;
            this.saldo = saldoPoczatkowe;
        }

        public void Wpłata(decimal kwota)
        {
            if (kwota < 0) throw new Exception("Kwota nie moze byc ujemna");
            saldo += kwota;
            Console.WriteLine("Nastapila wplata na konto {0:d} kwoty {1:c}. Saldo po operacji {2:c}.", numerKonta, kwota, saldo);
        }

        public bool Wypłata(decimal kwota)
        {
            if (kwota < 0) throw new Exception("Kwota nie moze byc ujemna");
            if (saldo >= kwota)
            {
                saldo -= kwota;
                Console.WriteLine("Nastapila wyplata z konta {0:d} kwoty {1:c}. Saldo po operacji {2:c}.", numerKonta, kwota, saldo);
                return true;
            }
            else return false;
        }

        public void WyświetlSaldo()
        {
            Console.WriteLine("Saldo konta {0:d}: {1:c}.", numerKonta, saldo);
        }

        public static bool Przelew(Konto kontoPłatnika, Konto kontoOdbiorcy, decimal kwota)
        {
            if (kontoPłatnika.numerKonta == kontoOdbiorcy.numerKonta) throw new Exception("Nie jest możliwe wykonanie przelewu na to samo konto");

            Console.WriteLine("Przygotowanie do przelewu z konta {0:d} na konto {1:d} kwoty {2:c}.", kontoPłatnika.numerKonta, kontoOdbiorcy.numerKonta, kwota);

            //niebezpieczne ze względu na dostęp z wielu wątków!!
            if (kontoPłatnika.Wypłata(kwota))
            {
                kontoOdbiorcy.Wpłata(kwota);
                Console.WriteLine("Wykonany zostal przelew z konta {0:d} na konto {1:d} kwoty {2:c}.", kontoPłatnika.numerKonta, kontoOdbiorcy.numerKonta, kwota);
                return true;
            }
            return false;            
        }
    }

    interface IPolecenie
    {
        bool CzyMożnaWykonać();
        void Wykonaj();
    }

    class PoleceniePrzelewu : IPolecenie
    {
        private Konto kontoPłatnika, kontoOdbiorcy;
        private decimal kwota;
        private bool wykonany = false;

        public PoleceniePrzelewu(Konto kontoPłatnika, Konto kontoOdbiorcy, decimal kwota)
        {
            this.kontoPłatnika = kontoPłatnika;
            this.kontoOdbiorcy = kontoOdbiorcy;
            this.kwota = kwota;
        }

        public bool CzyMożnaWykonać()
        {
            return !wykonany && kwota > 0;
        }

        public void Wykonaj()
        {
            if (wykonany) throw new Exception("Próba ponownego wykonania przelewu");
            Konto.Przelew(kontoPłatnika, kontoOdbiorcy, kwota);
            wykonany = true;
        }
    }

    class RelayCommand : IPolecenie
    {
        private Func<bool> czyMożnaWykonać;
        private Action wykonaj;

        public RelayCommand(Action wykonaj, Func<bool> czyMożnaWykonać = null)
        {
            this.czyMożnaWykonać = czyMożnaWykonać;
            if(wykonaj == null) throw new Exception("Polecenie puste");
            this.wykonaj = wykonaj;
        }

        public bool CzyMożnaWykonać()
        {
            if (czyMożnaWykonać != null) return czyMożnaWykonać();
            else return true;
        }

        public void Wykonaj()
        {
            wykonaj();
        }
    }
}
