﻿using System;

namespace UMK.WzorceOperacyjne
{
    //https://sourcemaking.com/design_patterns/observer/cpp/1

    interface IObserwator
    {
        void Aktualizuj(int dzielna);
    }

    class Dzielenie : IObserwator
    {
        private int wartość = 0;
        private int dzielnik;

        public Dzielenie(int dzielnik)
        {
            this.dzielnik = dzielnik;
        }

        public void Aktualizuj(int dzielna)
        {
            wartość = dzielna / dzielnik;
            Console.WriteLine("{0} / {1} = {2}", dzielna, dzielnik, wartość);
        }
    }

    class Modulo : IObserwator
    {
        private int wartość = 0;
        private int dzielnik;

        public Modulo(int dzielnik)
        {
            this.dzielnik = dzielnik;
        }

        public void Aktualizuj(int dzielna)
        {
            wartość = dzielna % dzielnik;
            Console.WriteLine("{0} % {1} = {2}", dzielna, dzielnik, wartość);
        }
    }

    class Podmiot
    {
        private int wartość;
        //private IObserwator dzielenie; //obiekty, których stan zależy od zmieniającego się pola wartość
        //private IObserwator modulo;
        private List<IObserwator> obserwatorzy = new List<IObserwator>();

        private void powiadom()
        {
            //dzielenie.Aktualizuj(wartość);
            //modulo.Aktualizuj(wartość);
            foreach(IObserwator obserwator in obserwatorzy)
                obserwator.Aktualizuj(wartość);
        }

        public Podmiot(params IObserwator[] obserwatorzy)
        {
            wartość = 0;
            //dzielenie = new Dzielenie(3);
            //modulo = new Modulo(3);
            if(obserwatorzy != null) this.obserwatorzy.AddRange(obserwatorzy);
        }

        public void DodajObserwatora(IObserwator obserwator)
        {
            if(obserwator != null) obserwatorzy.Add(obserwator);
        }

        public void UsuńObserwatora(IObserwator obserwator)
        {
            if(obserwator != null) obserwatorzy.Remove(obserwator);
        }

        public void ZmieńWartość(int nowaWartość)
        {
            wartość = nowaWartość;
            powiadom();
        }
    }
}