﻿namespace MetodaSzablonowa
{
    abstract class Pizza
    {
        private void przygotuj()
        {
            przygotujCiasto();
            posmarujSosem();
            dodajSer();
            dodajDodatki();
            dodajPrzyprawy();
        }

        protected virtual void przygotujCiasto()
        {
            Console.WriteLine("Przygotowuję cieńkie ciasto");
        }

        protected virtual void posmarujSosem()
        {
            Console.WriteLine("Smaruję sosem pomidorowym");
        }

        protected virtual void dodajSer()
        {
            Console.WriteLine("Dodaję mozarellę");
        }

        protected abstract void dodajDodatki();

        protected abstract void dodajPrzyprawy();

        public Pizza()
        {
            przygotuj();
        }
    }

    class PizzaMargaritha : Pizza
    {
        protected override void dodajDodatki()
        {
            Console.WriteLine("Dodaję bazylę i odrobię oliwy");
        }

        protected override void dodajPrzyprawy()
        {
            Console.WriteLine("Dodaję oregano");
        }
    }

    class PizzaSycylijska : Pizza
    {
        protected override void przygotujCiasto()
        {
            Console.WriteLine("Przygotowuję grube ciasto");
        }

        protected override void dodajDodatki()
        {
            Console.WriteLine("Dodaję cebulę, anchois i oregano");
        }

        protected override void dodajPrzyprawy()
        {
            Console.WriteLine("Posypuję parmezanem");
        }
    }

    internal class Program
    {
        static void Main(string[] args)
        {
            Pizza pm = new PizzaMargaritha();
            Pizza ps = new PizzaSycylijska();
        }
    }
}
