﻿using System;

namespace UMK.WzorceOperacyjne
{
    //wzorowane na przykładzie C++ z https://sourcemaking.com/design_patterns/interpreter/cpp/1

    class InterpreterLiczbRzymskich
    {
        //ogólny mechanizm interpretacji liczb rzymskich
        protected virtual void interpretuj(ref string liczbaRzymska, ref int wartość)
        {
            if (liczbaRzymska.Length == 0) return;

            int indeks = 0; //liczba zinterpretowanych znaków
            if (liczbaRzymska.Length >= 2 && liczbaRzymska.Substring(0, 2).Equals(new string(dziewięć())))
            {
                wartość += 9 * mnożnik();
                indeks += 2;
            }
            else if (liczbaRzymska.Length >= 2 && liczbaRzymska.Substring(0, 2).Equals(new string(cztery())))
            {
                wartość += 4 * mnożnik();
                indeks += 2;
            }
            else
            {
                if (liczbaRzymska[0] == pięć())
                {
                    wartość += 5 * mnożnik();
                    indeks = 1;
                }
                else indeks = 0;
                for (int end = liczbaRzymska.Length; indeks < end; indeks++) //od końca
                {
                    if (liczbaRzymska[indeks] == jeden())
                        wartość += 1 * mnożnik();
                    else break;
                }
            }
            liczbaRzymska = liczbaRzymska.Substring(indeks); //usunięcie znaków już zinterpretowanych
        }

        protected InterpreterLiczbRzymskich(int wartość) { } //konstruktor dla klas potomnych, argument zapobiega nieskonczonym pętlom

        //te metody nie mogą być czysto wirtualne, bo tworzymy obiekt tej klasy
        protected virtual char jeden() { return '\0'; }
        protected virtual char[] cztery() { return "\0".ToCharArray(); } //tablica znaków, bo dwuznakowy łańcuch np. IV
        protected virtual char pięć() { return '\0'; }
        protected virtual char[] dziewięć() { return "\0".ToCharArray(); } //j.w.
        protected virtual int mnożnik() { return 0; }
        protected virtual int Mnożnik
        {
            get
            {
                return 0;
            }
        }

        private InterpreterLiczbRzymskich interpreterTysiecy;
        private InterpreterLiczbRzymskich interpreterSetek;
        private InterpreterLiczbRzymskich interpreterDziesiątek;
        private InterpreterLiczbRzymskich interpreterJedności;

        public InterpreterLiczbRzymskich()
        {
            interpreterTysiecy = new InterpreterTysięcy();
            interpreterSetek = new InterpreterSetek();
            interpreterDziesiątek = new InterpreterDziesiątek();
            interpreterJedności = new InterpreterJedności();
        }

        public int Interpretuj(string liczbaRzymska)
        {
            int wartość = 0;
            interpreterTysiecy.interpretuj(ref liczbaRzymska, ref wartość);
            interpreterSetek.interpretuj(ref liczbaRzymska, ref wartość);
            interpreterDziesiątek.interpretuj(ref liczbaRzymska, ref wartość);
            interpreterJedności.interpretuj(ref liczbaRzymska, ref wartość);
            if (!string.IsNullOrEmpty(liczbaRzymska)) //jeżeli błąd
                throw new Exception("Interpretacja liczby w systemie Rzymskim nie powiodla sie.");
            return wartość;
        }
    }

    class InterpreterJedności : InterpreterLiczbRzymskich
    {

        public InterpreterJedności()
            : base(0)
        { }

        protected override char jeden()
        {
            return 'I';
        }
        protected override char[] cztery()
        {
            return "IV".ToCharArray();
        }
        protected override char pięć()
        {
            return 'V';
        }
        protected override char[] dziewięć()
        {
            return "IX".ToCharArray();
        }
        protected override int mnożnik()
        {
            return 1;
        }
    }

    class InterpreterDziesiątek : InterpreterLiczbRzymskich
    {

        public InterpreterDziesiątek()
            : base(0)
        { }

        protected override char jeden()
        {
            return 'X';
        }
        protected override char[] cztery()
        {
            return "XL".ToCharArray();
        }
        protected override char pięć()
        {
            return 'L';
        }
        protected override char[] dziewięć()
        {
            return "XC".ToCharArray();
        }
        protected override int mnożnik()
        {
            return 10;
        }
    }

    class InterpreterSetek : InterpreterLiczbRzymskich
    {
        public InterpreterSetek()
            :base(0)
        { }

        protected override char jeden()
        {
            return 'C';
        }

        protected override char[] cztery()
        {
            return "CD".ToCharArray();
        }

        protected override char pięć()
        {
            return 'D';
        }

        protected override char[] dziewięć()
        {
            return "CM".ToCharArray();
        }

        protected override int mnożnik()
        {
            return 100;
        }
    };

    class InterpreterTysięcy : InterpreterLiczbRzymskich
    {
        //jest tylko M

        public InterpreterTysięcy()
            : base(0)
        { }

        protected override char jeden()
        {
            return 'M';
        }
        protected override char[] cztery()
        {
            return "".ToCharArray();
        }
        protected override char pięć()
        {
            return '\0';
        }
        protected override char[] dziewięć()
        {
            return "".ToCharArray();
        }
        protected override int mnożnik()
        {
            return 1000;
        }
    }
}
