﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Singleton12
{
    class Program
    {
        class Klasa
        {
            public void Metoda()
            {
                Log log = Log.PobierzInstancję();
                log.Dodaj("B");
            }
        }

        static void Main(string[] args)
        {
            Log log = Log.PobierzInstancję();
            log.Dodaj("A");
            new Klasa().Metoda();
            log.Dodaj("C");
            log.Zapisz();
        }

        class Log
        {
            #region Singleton
            private Log() { }

            private static Log instancja = null; //TODO: leniwa inicjacja

            public static Log PobierzInstancję()
            {
                if (instancja == null) instancja = new Log();
                return instancja;
            }
            #endregion

            //private IFormatProvider fp = System.Globalization.CultureInfo.InvariantCulture; //USA
            private IFormatProvider fp = new System.Globalization.CultureInfo("pl-PL"); //Polska
            private string ścieżka = System.IO.Path.Combine(System.Environment.GetFolderPath(Environment.SpecialFolder.UserProfile), "log.txt");

            private List<string> komunikaty = new List<string>();

            public void Dodaj(string komunikat)
            {
                komunikaty.Add(DateTime.Now.ToString(fp) + " - " + komunikat);
            }

            public void Zapisz()
            {
                System.IO.File.WriteAllLines(ścieżka, komunikaty);
            }
        }
    }
}
