﻿using System;

namespace Polecenie
{
    class Program
    {
        static void Main(string[] args)
        {
            try //powinno być wokół każdego przelewu osobno
            {
                Konto konto1 = new Konto(1, 100);
                Konto konto2 = new Konto(2, 150);
                List<IPolecenie> polecenia = new List<IPolecenie>();

                konto1.WyświetlSaldo();
                konto2.WyświetlSaldo();

                //Konto.Przelew(konto1, konto2, 50);
                PoleceniePrzelewu przelew1 = new PoleceniePrzelewu(konto1, konto2, 50);
                polecenia.Add(przelew1);

                konto1.WyświetlSaldo();
                konto2.WyświetlSaldo();

                //Konto.Przelew(konto2, konto1, 100);
                //PoleceniePrzelewu przelew2 = new PoleceniePrzelewu(konto2, konto1, 100);
                PoleceniePrzekaźnikowe przelew2 = new PoleceniePrzekaźnikowe(() => { Konto.Przelew(konto2, konto1, 100); });
                polecenia.Add(przelew2);

                konto1.WyświetlSaldo();
                konto2.WyświetlSaldo();

                //if (przelew1.CzyMożnaWykonć()) przelew1.Wykonaj();
                //if (przelew2.CzyMożnaWykonć()) przelew2.Wykonaj();                
                foreach (IPolecenie polecenie in polecenia)
                    if (polecenie.CzyMożnaWykonć())
                        polecenie.Wykonaj();

                konto1.WyświetlSaldo();
                konto2.WyświetlSaldo();
            }
            catch (Exception exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message);
            }
        }
    }
}
