﻿using System.Collections;
using System.Diagnostics;
using System.Reflection.Metadata.Ecma335;

namespace Kompozyt10
{
    public interface IOdwiedzający
    {
        void Odwiedź(Pracownik pracwnik);
    }

    public class Pracownik
    {
        private string imię, nazwisko, stanowisko;
        protected internal bool odwiedzony = false;

        public Pracownik(string imię, string nazwisko, string stanowisko)
        {
            this.imię = imię;
            this.nazwisko = nazwisko;
            this.stanowisko = stanowisko;
        }

        public override string ToString()
        {
            return $"{imię} {nazwisko} ({stanowisko})";
        }

        /*
        public virtual void WyświetlInformacje(int głębokość)
        {            
            zróbWcięcie(głębokość);
            Console.WriteLine($"{imię} {nazwisko} ({stanowisko})");
            odwiedzony = true;
        }
        */

        public virtual void PrzyjmijWizytę(IOdwiedzający odwiedzający, int głębokość)
        {
            //zróbWcięcie(głębokość);
            //Console.WriteLine($"{imię} {nazwisko} ({stanowisko})");
            odwiedzający.Odwiedź(this);
            odwiedzony = true;
        }

        protected void zróbWcięcie(int głębokość)
        {
            for (int i = 0; i < głębokość; i++) Console.Write(' ');
        }

        public virtual void Resetuj()
        {
            odwiedzony = false;
        }
    }

    public class Kierownik : Pracownik, IEnumerable<Pracownik>
    {
        private List<Pracownik> podwładni = new List<Pracownik>();

        public Kierownik(string imię, string nazwisko, string stanowisko, Pracownik[]? podwładni = null)
            :base(imię, nazwisko, stanowisko)
        {
            if(podwładni != null && podwładni.Length > 0)
                this.podwładni.AddRange(podwładni);
        }

        public void DodajPodwładnego(Pracownik podwładny)
        {
            if(podwładni != null) podwładni.Add(podwładny);
        }

        private static int? głębokośćPierwszegoKierownika = null;

        /*
        public override void WyświetlInformacje(int głębokość)
        {
            if (głębokośćPierwszegoKierownika == null) głębokośćPierwszegoKierownika = głębokość;

            base.WyświetlInformacje(głębokość);
            zróbWcięcie(głębokość);
            Console.WriteLine("Podwładni:");
            foreach (Pracownik podwładny in podwładni)
            {
                if (!podwładny.odwiedzony)
                    podwładny.WyświetlInformacje(głębokość + 1);
                else Console.WriteLine("Wykryto cykl");
            }

            if (głębokość == głębokośćPierwszegoKierownika)
            {
                Resetuj();
            }

        }
        */

        public override void PrzyjmijWizytę(IOdwiedzający odwiedzający, int głębokość = 0)
        {
            if (głębokośćPierwszegoKierownika == null) 
                głębokośćPierwszegoKierownika = głębokość;

            //base.WyświetlInformacje(głębokość);
            base.PrzyjmijWizytę(odwiedzający, głębokość);
            //zróbWcięcie(głębokość);
            //Console.WriteLine("Podwładni:");
            foreach (Pracownik podwładny in podwładni)
            {
                if (!podwładny.odwiedzony)
                    //podwładny.WyświetlInformacje(głębokość + 1);
                    podwładny.PrzyjmijWizytę(odwiedzający, głębokość + 1);
                else Console.WriteLine("Wykryto cykl");
            }

            if (głębokość == głębokośćPierwszegoKierownika)
                Resetuj();
        }

        public override void Resetuj()
        {
            base.Resetuj();
            foreach (Pracownik podwładny in podwładni)
                if (podwładny.odwiedzony)
                    podwładny.Resetuj();            
        }

        #region Iterator
        class OdwiedzającySpłaszczający : IOdwiedzający
        {
            public List<Pracownik> Pracownicy { get; private set; } = new List<Pracownik>();

            public void Odwiedź(Pracownik pracownik)
            {
                Pracownicy.Add(pracownik);
            }
        }

        public IEnumerator<Pracownik> GetEnumerator()
        {
            /*
            OdwiedzającySpłaszczający os = new OdwiedzającySpłaszczający();
            PrzyjmijWizytę(os);
            List<Pracownik> lista = os.Pracownicy;
            return lista.GetEnumerator();
            */
            return new IteratorPodwładnych(this);
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }
        #endregion
    }

    public class IteratorPodwładnych : IEnumerator<Pracownik>
    {
        private int? indeksBieżącegoPodwładnego = null;
        List<Pracownik> listaPodwładnych = null;

        public IteratorPodwładnych(Kierownik kierownik)
        {
            OdwiedzającySpłaszczający os = new OdwiedzającySpłaszczający();
            kierownik.PrzyjmijWizytę(os);
            listaPodwładnych = os.Pracownicy;
        }

        public Pracownik Current => listaPodwładnych[indeksBieżącegoPodwładnego.HasValue?indeksBieżącegoPodwładnego.Value:0];

        object IEnumerator.Current => Current;

        public void Dispose()
        {
            //nie mamy nic do zrobienia
        }

        public bool MoveNext()
        {
            if (indeksBieżącegoPodwładnego == null) indeksBieżącegoPodwładnego = 0;
            else indeksBieżącegoPodwładnego++;
            return indeksBieżącegoPodwładnego < listaPodwładnych.Count;
        }

        public void Reset()
        {
            indeksBieżącegoPodwładnego = null;
        }
    }

    class OdwiedzającyWyświetlającyInformacje : IOdwiedzający
    {
        public void Odwiedź(Pracownik pracownik)
        {
            Console.WriteLine(pracownik);
        }
    }

    class OdwiedzającySpłaszczający : IOdwiedzający
    {
        public List<Pracownik> Pracownicy { get; private set; } = new List<Pracownik>();

        public void Odwiedź(Pracownik pracownik)
        {
            Pracownicy.Add(pracownik);
        }
    }
}
