﻿using System;

namespace UMK.WzorceStrukturalne
{
    //component
    abstract class Napój
    {
        public abstract decimal Cena();
        public void Objętość() //funckja nie podlegająca zmianom podczas dekoracji
        {
            Console.WriteLine("\nObjetosc: 330 ml");
        }
    }

    //concrete components
    class Herbata : Napój
    {
        public override decimal Cena()
        {
            return 6.70M;
        }

        public override string ToString()
        {
            return "Herbata";
        }
    }

    class Kawa : Napój
    {
        public override decimal Cena()
        {
            return 7.90M;
        }

        public override string ToString()
        {
            return "Kawa";
        }
    }

    //(abstract) decorator
    abstract class NapójZDodatkiem : Napój
    {
        protected Napój napój;

        public NapójZDodatkiem(Napój napój)
        {
            this.napój = napój;
        }
    }

    //concrete decorator
    class NapójZCukrem : NapójZDodatkiem
    {
        public NapójZCukrem(Napój napój)
            : base(napój)
        { }

        public override decimal Cena()
        {
            return napój.Cena() + 0.5M;
        }

        public override string ToString()
        {
            return napój.ToString() + " z cukrem";
        }
    }

    class NapójZCytryną : NapójZDodatkiem
    {
        private int liczbaPlastrów;

        public NapójZCytryną(Napój napój, int liczbaPlastrów = 1)
            : base(napój)
        {
            this.liczbaPlastrów = liczbaPlastrów;
        }

        public override decimal Cena()
        {
            return napój.Cena() + liczbaPlastrów * 1M;
        }

        public override string ToString()
        {
            return napój.ToString() + $" z {liczbaPlastrów} plastrami cytryny";
        }
    }

    class NapójZeSzczyptąCynamonu : NapójZDodatkiem
    {
        public NapójZeSzczyptąCynamonu(Napój napój)
            : base(napój)
        {
        }

        public override decimal Cena()
        {
            return napój.Cena() + 3M;
        }

        public override string ToString()
        {
            return napój.ToString() + " ze szczyptą cynamonu";
        }
    }
}
