﻿using System.Diagnostics;
using System.Numerics;
using System.Runtime.InteropServices;

namespace Kompozyt
{
    class OdwiedzającyDrukujący : IOdwiedzający
    {
        public void Odwiedź(IPracownik pracownik)
        {
            Console.WriteLine(pracownik);
        }
    }

    class OdwiedzającyZliczający : IOdwiedzający
    {
        public int Licznik { get; private set; } = 0;

        public void Odwiedź(IPracownik pracownik)
        {
            Licznik++;
        }
    }

    class OdwiedzającySpłaszczający : IOdwiedzający
    {
        private List<IPracownik> lista = new List<IPracownik>();

        public IPracownik[] Tablica
        {
            get
            {
                return lista.ToArray();
            }
        }
        public void Odwiedź(IPracownik pracownik)
        {
            lista.Add(pracownik);
        }
    }

    public static class Rozszerzenia
    {
        public static int Licz(this Kierownik kierownik)
        {
            OdwiedzającyZliczający oz = new OdwiedzającyZliczający();
            kierownik.PrzyjmijWizytę(oz);
            return oz.Licznik;
        }

        public static IPracownik[] DoTablicy(this Kierownik kierownik)
        {
            OdwiedzającySpłaszczający os = new OdwiedzającySpłaszczający();
            kierownik.PrzyjmijWizytę(os);
            return os.Tablica;
        }
    }

    internal class Program
    {
        static void Main(string[] args)
        {
            Kierownik rektor = new Kierownik("Andrzej", "Tretyn", "rektor");
            Pracownik prorektor = new Pracownik("Adam", "Kola", "prorektor ds. nauki");
            Kierownik dziekan = new Kierownik("Winicjusz", "Drozdowski", "dziekan WFAiIS");
            Kierownik kierownikKatedry = new Kierownik("Norbert", "Jankowski", "kierownik KIS");
            Pracownik pracownikKIS1 = new Pracownik("Jacek", "Matulewski", "pracownik KIS");
            Pracownik pracownikKIS2 = new Pracownik("Łukasz", "Sikorski", "pracownik KIS");

            rektor.DodajPodwładnego(prorektor);
            rektor.DodajPodwładnego(dziekan);
            dziekan.DodajPodwładnego(kierownikKatedry);
            kierownikKatedry.DodajPodwładnego(pracownikKIS1);
            kierownikKatedry.DodajPodwładnego(pracownikKIS2);
            kierownikKatedry.DodajPodwładnego(rektor);

            //rektor.WyświetlInformacje();
            //rektor.WyświetlInformacje();
            rektor.PrzyjmijWizytę(new OdwiedzającyDrukujący());

            OdwiedzającyZliczający oz = new OdwiedzającyZliczający();
            rektor.PrzyjmijWizytę(oz);
            Console.WriteLine(oz.Licznik);
            rektor.Licz();

            Console.WriteLine(rektor.DoTablicy().Length);
        }
    }
}
