﻿using System;

namespace UMK.WzorceStrukturalne
{
    class Znak
    {
        //stan wewnętrzny
        protected char litera;        

        public Znak(char litera)
        {
            this.litera = litera;
        }

        public void Wyświetl(ConsoleColor kolor)
        {
            ConsoleColor oryginalnyKolor = Console.ForegroundColor;
            Console.ForegroundColor = kolor;
            Console.Write(litera);
            Console.ForegroundColor = oryginalnyKolor;
        }
    }

    class ZnakA : Znak 
    { 
        public ZnakA()
            :base('A') { }
    }

    class ZnakB : Znak
    {
        public ZnakB()
            : base('B') { }
    }

    class ZnakC : Znak
    {
        public ZnakC()
            : base('C') { }
    }

    class ZnakD : Znak
    {
        public ZnakD()
            : base('D') { }
    }

    class ZnakJ : Znak
    {
        public ZnakJ()
            : base('J') { }
    }

    class ZnakU : Znak
    {
        public ZnakU()
            : base('U') { }
    }

    class ZnakPusty : Znak //znak nierozpoznany, inny
    {
        public ZnakPusty()
            : base('?') { }
    }

    //Fabryka
    class FabrykaZnaków
    {
        private Dictionary<char, Znak> znaki = new Dictionary<char, Znak>();

        public Znak PobierzZnak(char litera)
        {
            Znak znak;
            if (znaki.ContainsKey(litera)) znak = znaki[litera];
            else
            {
                switch (litera)
                {
                    case 'A': znak = new ZnakA(); break;
                    case 'B': znak = new ZnakB(); break;
                    case 'C': znak = new ZnakC(); break;
                    case 'D': znak = new ZnakD(); break;
                    case 'J': znak = new ZnakJ(); break;
                    case 'U': znak = new ZnakU(); break;
                    default: znak = new ZnakPusty(); break;
                }
                znaki.Add(litera, znak);
            }
            return znak;
        }
    }
}