﻿using System;
using System.Windows;

using System.Runtime.InteropServices;
using System.Diagnostics;
using System.Windows.Interop;

namespace WpfApp1
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {

       


        public MainWindow()
        {
            InitializeComponent();

            string katalogGlownyDysku = System.Environment.GetLogicalDrives()[0]; //"C:\\"
            int procentZajetosci = WolneMiejsceNaDysku(katalogGlownyDysku);
            if (procentZajetosci >= 0) progressBar1.Value = procentZajetosci;
        }

        protected override void OnSourceInitialized(EventArgs e)
        {
            base.OnSourceInitialized(e);

            var hwndSource = PresentationSource.FromVisual(this) as HwndSource;
            if (hwndSource != null)
            {
                hwndSource.AddHook(WndProc);
            }

        }

        private IntPtr WndProc(IntPtr hwnd, int msg, IntPtr wParam, IntPtr lParam, ref bool handled)
        {
            var message = (WindowMessage)msg;
            if (checkBox1.IsChecked == true)
                listBox1.Items.Add(message.ToString() + ", hwnd:" + hwnd.ToString() + ", wparam:" + wParam.ToString() + ", lparam:" + lParam.ToString());
            

            return IntPtr.Zero;
        }
    


        private void Button_Click(object sender, RoutedEventArgs e)
        {
            
            Process[] processes = Process.GetProcessesByName("notepad");
            if (processes.Length > 0)
            //    MessageBox.Show("Znalazłem " + processes.Length + " procesów");
            {
                string tekst = textBox1.Text;
                IntPtr x = Marshal.StringToHGlobalAnsi(tekst);

                for (int i = 0; i < processes.Length; i++)
                {
                    IntPtr hEdit = WinAPI.FindWindowEx(processes[i].MainWindowHandle, IntPtr.Zero,
                        "Edit", "");

                    WinAPI.SendMessage(hEdit, WinAPI.WM_SETTEXT, IntPtr.Zero, x);

                }

                Marshal.FreeHGlobal(x);
            }
            else
                MessageBox.Show("Nie znaleziono żadnego procesu notatnika.\nUruchom najpierw \"notepad.exe\"");
        }

        

        private void Button_Click_1(object sender, RoutedEventArgs e)
        {
            // string text = textBox2.Text;
            if (Process.Start("notepad") == null)
                MessageBox.Show("Błąd! Nie uruchomiono procesu: ");
        }

        private int WolneMiejsceNaDysku(string katalogGlownyDysku)
        {
            int wolneMiejsceNaDyskuProcenty;
            ulong wolneMiejsceDlaUzytkownika = 0;
            ulong rozmiarDysku = 0;
            ulong wolneMiejsceNaDysku = 0;
            if (WinAPI.GetDiskFreeSpaceEx(katalogGlownyDysku,
                  out wolneMiejsceDlaUzytkownika,
                  out rozmiarDysku,
                  out wolneMiejsceNaDysku))
            {
                wolneMiejsceNaDyskuProcenty = (int)(100 * (rozmiarDysku - wolneMiejsceNaDysku) / (double)rozmiarDysku);
            }
            else
            {
                wolneMiejsceNaDyskuProcenty = -1;
            }
            return wolneMiejsceNaDyskuProcenty;
        }

    }
}
