function [ppi dpii projection G]=ppitestfunction(x,y,w,func,worto,lambda)
% funkcja testowa, tylko do zabawy

% PPIFUNCTION computes value of PPIndex.
%
%    PPI = PPIFUNCTION(X,Y,W) computes value of PPIndex for given dataset
%    X, label table Y and direction W (weights).
%
%    PPI = PPIFUNCTION(X,Y,W,FUNC) computes value of PPIndex with given function FUNC (function handle, default FUNC=@(x)F_X4(x,3)).
%
%    [PPI DPPI] = PPIFUNCTION(...) returns value of gradient df/dx, the
%    function FUNC must return it's gradient value as a secound output.
%
%    [PPI DPPI PROJ] = PPIFUNCTION(...) returns value of X*W', for some
%    reasons may be usefull.
%
%   [PPI DPPI PROJ G] = PPIFUNCTION(...) returns table of values of PPI
%   index partial values for each vector. G_i = sum_k FUNC( (X_i - X_k)*W')
%   


%Funkcja oblicza wartosc indexsu ppi, dla danych wektorow X oraz etykiet
% klas Y oraz podanego kierunku W i funkcji FUNC.
% Wartosci zwracane: 
%   PPI  - wartosc indexu
%   DPPI - pochodna funkcji 
%   PROJ - rzyt x*w' - mozna wykozystac w dalszych obliczeniach aby nie
%           powtarzac tej operacji wielokratnie
%   G    - tablica wartosci dla kazdego z wektorow  PPI = 1/A sum G(x)

if nargin < 6
    lambda = 1;
end
if ( nargin < 5 )
    lambda = 0;
end

if  nargin < 4 || isempty(func)
    func=@(x)f_x4(x,3);
 %   disp('Function FUNC not set - using default value FUNC=@f_x4');
end

[vectorsCount featuresCount] = size(x);
[labels a index] = unique(y);
classCount = size(labels,1);
labelIndex = zeros(vectorsCount,classCount); % macierz IxJ zawierajaca 1 gdy I-ty wektor nalezy do klasy J-tej, w przeciwnym razie 0
for i=1:classCount
    labelIndex(:,i) = (index == i);
end
labelsCount=sum(labelIndex);

projection = x*w';
G = zeros(1,vectorsCount);

if nargout > 1
    dpii =zeros(1,featuresCount);
end

gplus = 0;
gminus =0;

for i=1:vectorsCount
    ii=index(i);
    [f df] = func(projection - projection(i));
    ap = labelsCount(ii);
    plus = sum(labelIndex(:,ii).*f)./ap;
    am = (vectorsCount-labelsCount(ii));
    minus = sum((~labelIndex(:,ii)).*f)./am;
%    G(i) = plus - minus;
    gplus = gplus + plus;
    gminus = gminus + minus;
    if nargout > 1
        xd = x - ones(vectorsCount,1)*x(i,:) ;
        dplus = ((labelIndex(:,ii).*df)'*xd)./labelsCount(ii);
        dminus = (((~labelIndex(:,ii)).*df)' * xd)./(vectorsCount-labelsCount(ii));
        dpii = dpii + dplus - dminus;
    end
    
end
disp([gplus gminus]);
G = gplus - gminus;
ppi = sum(G) /vectorsCount;
if nargout > 1
    dpii =dpii./vectorsCount;
end
if lambda ~= 0
   % tutaj czesc ortonormalizacyjna
   [fw dfw]=ortof(w,worto,lambda);
   ppi = ppi  - fw;
   if nargout > 1
        dpii = dpii - dfw;
   end
end
