function [avgacc avgstd avgneurons stdneurons accall nodes]=multitest(x,y,folds,repetitions)
% x - input data
% y - labels
% trainmodel - function handle $(x,y)f() that learns model

if nargin < 4
    repetitions = 1;
end

if nargin < 3
    folds = 10;
end

traintransform=@(x)normalize(x);
testtransform=@(x,a)normalize(x,a);

model = @(xx,yy)ppinetwork(xx,yy,'display','short','plot','none','beta',2,'learningRate',0.2,'initiations',100,'maxIterations',1000);
testmodel = @(xx,yy,zz)nettest(xx,yy,zz);

vectors=size(x,1);

fv = floor(vectors/folds);
rest = vectors - fv*folds;

accall=zeros(folds,repetitions);
nodes = zeros(folds,repetitions);


for n=1:repetitions
    perm = randperm(vectors);
    
    ip = 1; 
    for i=1:folds
        fprintf('\n=======  Test %d fold %d ========================\n\n',n,i);

        fvc = fv;
        if rest > 0
              fvc = fvc + 1;
              rest = rest - 1;
        end
        indexes = zeros(vectors,1);
        ik = ip + fvc;
        indexes(ip:ik-1)=1;
        
        % train = x(perm(indexes == 1),:)
        [train a]=traintransform(x(perm(indexes == 0),:));
        
        net = model(train,y(perm(indexes == 0)));
        nodes(i,n)=size(net,2);
%        net = model(x(perm(indexes == 0),:),y(perm(indexes == 0)));
        % test =  x(perm(indexes == 0),:)
        curracc=testmodel(testtransform(x(perm(indexes == 1),:),a),y(perm(indexes == 1)),net);
%        if display > 0
            fprintf(' Test acc. %4.1f\n',curracc);
 %       end
        accall(i,n)=curracc;
        ip = ik;
   end
end

fprintf('\n\nNeurons\n');
[avgneurons stdneurons]=printresults(nodes);

fprintf('\n\nTest accuracy\n');
[avgacc avgstd]=printresults(accall);
return

function [mean2 std2]=printresults(table)
    [folds tests]=size(table);
    fprintf('Test : %s \n',sprintf(' %6d',1:tests));
    fprintf('------ \n');
    for i=1:folds
        fprintf('%2d fold %s\n',i,sprintf(' %6.2f',table(i,:)));
    end
    fprintf('------ \n');
    mean1 = mean(table);  
    std1  = std(table);
    mean2=mean(mean1); std2=std(mean1);
    mean3=mean(std1); std3=std(std1);

    fprintf('Avg  : %s | avg. %6.2f    std. %6.2f\n',sprintf(' %6.2f',mean1),mean2,std2);
    fprintf('Std  : %s | avg. %6.2f    std. %6.2f\n',sprintf(' %6.2f',std1),mean3,std3);

    return;
