function [y dy]=f_x4(x,b,c)
%   
%   Y = F_X4(X,B,C)
%
%	compute value of function y(x)=1/(1+(b*(x-c))^4)
%	B  : function width (default 1)
%	C  : center (default 0)
%
% [Y DY]=F_X4(X,A,C)
%
%    returns DY - value of gradient df/dx
%
% Note that   F_X4(X,B,C) = F_X4( B(X-C) )
%


if nargin < 3
     c = 0;
end;
if nargin < 2
       b = 1;
end;

x=b*(x-c); 
x2=x.*x;
m=x2.*x2+1;
y=1./m;

if nargout > 1
    dy=-4*b*(x2.*x).*(y.*y);
end