#include <math.h>
#include "fmat.h"

/* funkcja oblicza silnie podanej liczby calkowitej */
int silnia(int n)
{
   int i=2, s=1;

   while( i < n+1 )
   {
      s = s * i;
      i = i + 1;
   }
   return s;
}

/* oblicza potege x^w (gdzie 'w' jest liczba calkowita i nieulemna) */
float potega(float x,int w)
{
   int i;
   float wynik=1;

   for(i=0;i<w;i++)	wynik*=x;

	return wynik;
}

/* funkcja wyznacza miejsca zerowe rownania kwadratowego postaci a*x^2+b*x+c=0.
   Funkcja zwraca liczbe miejsc zerowych (0, 1 lub 2).
   Jezeli istnieja miejsca zerowe wowczas ich wartosc jest podstawiana do zmiennej
   wskazanej przez adresy x1 i x2 */
int pierwiastki (float a, float b, float c, float *x1, float *x2)
{
	float d;
	d=b*b-4*a*c;
	if (d<0) return 0;

	if (d==0)
	{
		*x1=-b/(2*a);
		*x2=*x1;
		return 1;
	}

	*x1=(-b+sqrt(d))/(2*a);
	*x2=(-b-sqrt(d))/(2*a);
	return 2;
}

/* oblicza potege x^w - rekurencyjnie */
float rpotega(float x,int w)
{
	if (w < 1) return 1;
	return x*potega(x,w-1);
}

/* funkcja oblicza silnie liczby calkowitej - rekurencyjnie */
int rsilnia(int n)
{
   if(n <= 1) return 1;
   return n*rsilnia(n-1);
}

/* Funkcja sprawdza czy dana liczba jest liczba pierwsza.
 * Wartoscia zwaracana jest 1 gdy dana liczba jest liczba pierwsza i
 * 0 w przeciwnym wypadku 	*/
int pierwsza(int n)
{
	int i=2;
	while(i<=n/2)
	{
		if (n%i==0) return 0;
		i++;
	}
	return 1;
}
