#include<stdio.h>

/*	Funkcja wczytuje do tablicy 'l[]' jedna linie tekstu z klawiatury (ale nie wiecej niz 'n' znakow).
 *	Wartoscia zwracana jest adres do tablizy znakow zawierajacej wczytany tekst (bez konczacego znaku nowej linii).
 *  Na koncu znajduje sie znak '\0'.
 */
char *czytajlinie(char *l,int n)
{
	int i=0;
	char *p;
	p=l;
	while (((i=getchar()) !=EOF) && (i!='\n') && (n>1))
	{
		*l=i;
		l++;
		n--;
	}
	*l='\0';
	return p;
}

/* Funkcja oblicza dlugosc napisu 't'.
 * Wartoscia zwracana jest liczba znakow w lancuchu (stringu) 't'
 */
int liczznaki(char *t)
{
	int i=0;
	while (*t!='\0')
	{
		i++;
		t++;
	}
	return i;
}

/* Funkcja kopiuje zawartosc tablicy 'co' do tablicy 'gdzie'.
 * Wartoscia zwracana jest adres (wskaznik) do skopiowanej tablicy znakow 'gdzie'.*/
char *kopia(char *co,char *gdzie)
{
	char *u=gdzie;
	while (*gdzie++=*co++);
	return u;
}

/* Funckja szuka lancucha 'wzor' w lancuchu 'napis'.
 * Wartoscia zwracana jest adres do poczatku pierwszego znalezionego lancucha 'wzor' wewnatrz 'napis'
 * lub NULL jesli ciag znakow 'napis' nie zawiera 'wzor'
 */
char *znajdz(char *napis, char *wzor)
{
	char *a=napis;
	char *wsk,*wsk2;
	while( *napis!='\0')
    {
    	wsk=napis;
        wsk2=wzor;
        while(*wsk==*wsk2 &&*wsk2!='\0')
 		{
 			wsk++;
   			wsk2++;
  		}
  		if(*wsk2=='\0') return napis;
   	  	napis++;
    }
    return NULL;
 }
